/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.AutoValue_PlainNamedIndividualFrame;
import edu.stanford.protege.webprotege.frame.PlainEntityFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

@JsonTypeName(value="IndividualFrame")
@AutoValue
public abstract class PlainNamedIndividualFrame
extends PlainEntityFrame {
    public static final String INDIVIDUAL_FRAME = "IndividualFrame";
    private static final String SAME_INDIVIDUAL = "sameIndividual";

    @JsonCreator
    @Nonnull
    public static PlainNamedIndividualFrame get(@Nonnull @JsonProperty(value="subject") OWLNamedIndividual subject, @Nonnull @JsonProperty(value="parents") ImmutableSet<OWLClass> parents, @Nonnull @JsonProperty(value="sameIndividual") ImmutableSet<OWLNamedIndividual> sameIndividuals, @Nonnull @JsonProperty(value="propertyValues") ImmutableSet<PlainPropertyValue> propertyValues) {
        return new AutoValue_PlainNamedIndividualFrame(subject, parents, sameIndividuals, propertyValues);
    }

    public static PlainNamedIndividualFrame empty(OWLNamedIndividual individual) {
        return PlainNamedIndividualFrame.get(individual, (ImmutableSet<OWLClass>)ImmutableSet.of(), (ImmutableSet<OWLNamedIndividual>)ImmutableSet.of(), (ImmutableSet<PlainPropertyValue>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLNamedIndividual getSubject();

    @Nonnull
    public abstract ImmutableSet<OWLClass> getParents();

    @JsonProperty(value="sameIndividual")
    @Nonnull
    public abstract ImmutableSet<OWLNamedIndividual> getSameIndividuals();

    @Nonnull
    public abstract ImmutableSet<PlainPropertyValue> getPropertyValues();

    @Override
    @Nonnull
    public PlainNamedIndividualFrame toPlainFrame() {
        return this;
    }
}

