/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.AutoValue_PlainObjectPropertyFrame;
import edu.stanford.protege.webprotege.frame.ObjectPropertyCharacteristic;
import edu.stanford.protege.webprotege.frame.PlainEntityFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;

@JsonTypeName(value="ObjectPropertyFrame")
@AutoValue
public abstract class PlainObjectPropertyFrame
extends PlainEntityFrame {
    public static final String OBJECT_PROPERTY_FRAME = "ObjectPropertyFrame";
    private static final String CHARACTERISTICS = "characteristics";
    public static final String DOMAINS = "domains";
    public static final String RANGES = "ranges";
    public static final String INVERSES = "inverses";

    @Nonnull
    @JsonCreator
    public static PlainObjectPropertyFrame get(@Nonnull @JsonProperty(value="subject") OWLObjectProperty subject, @Nonnull @JsonProperty(value="propertyValues") ImmutableSet<PlainPropertyAnnotationValue> annotationValues, @Nonnull @JsonProperty(value="characteristics") ImmutableSet<ObjectPropertyCharacteristic> characteristics, @Nonnull @JsonProperty(value="domains") ImmutableSet<OWLClass> domains, @Nonnull @JsonProperty(value="ranges") ImmutableSet<OWLClass> ranges, @Nonnull @JsonProperty(value="inverses") ImmutableSet<OWLObjectProperty> inverses) {
        return new AutoValue_PlainObjectPropertyFrame(subject, annotationValues, characteristics, domains, ranges, inverses);
    }

    public static PlainObjectPropertyFrame empty(OWLObjectProperty property) {
        return PlainObjectPropertyFrame.get(property, (ImmutableSet<PlainPropertyAnnotationValue>)ImmutableSet.of(), (ImmutableSet<ObjectPropertyCharacteristic>)ImmutableSet.of(), (ImmutableSet<OWLClass>)ImmutableSet.of(), (ImmutableSet<OWLClass>)ImmutableSet.of(), (ImmutableSet<OWLObjectProperty>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLObjectProperty getSubject();

    @Nonnull
    public abstract ImmutableSet<PlainPropertyAnnotationValue> getPropertyValues();

    @JsonProperty(value="characteristics")
    @Nonnull
    public abstract ImmutableSet<ObjectPropertyCharacteristic> getCharacteristics();

    @JsonProperty(value="domains")
    @Nonnull
    public abstract ImmutableSet<OWLClass> getDomains();

    @JsonProperty(value="ranges")
    @Nonnull
    public abstract ImmutableSet<OWLClass> getRanges();

    @JsonProperty(value="inverses")
    @Nonnull
    public abstract ImmutableSet<OWLObjectProperty> getInverseProperties();

    @Override
    @Nonnull
    public PlainObjectPropertyFrame toPlainFrame() {
        return this;
    }
}

