/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.entity.OWLPropertyData;
import edu.stanford.protege.webprotege.frame.PlainPropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyClassValue;
import edu.stanford.protege.webprotege.frame.PropertyDatatypeValue;
import edu.stanford.protege.webprotege.frame.PropertyIndividualValue;
import edu.stanford.protege.webprotege.frame.PropertyLiteralValue;
import edu.stanford.protege.webprotege.frame.PropertyValueVisitor;
import edu.stanford.protege.webprotege.frame.State;
import java.io.Serializable;
import javax.annotation.Nonnull;

@JsonSubTypes(value={@JsonSubTypes.Type(value=PropertyClassValue.class), @JsonSubTypes.Type(value=PropertyIndividualValue.class), @JsonSubTypes.Type(value=PropertyDatatypeValue.class), @JsonSubTypes.Type(value=PropertyLiteralValue.class), @JsonSubTypes.Type(value=PropertyAnnotationValue.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
public abstract class PropertyValue
implements Comparable<PropertyValue>,
Serializable {
    public abstract OWLPropertyData getProperty();

    public abstract OWLPrimitiveData getValue();

    public abstract State getState();

    @JsonIgnore
    public abstract boolean isValueMostSpecific();

    @JsonIgnore
    public abstract boolean isAnnotation();

    @JsonIgnore
    public abstract boolean isLogical();

    public abstract <R, E extends Throwable> R accept(PropertyValueVisitor<R, E> var1) throws E;

    public PropertyValue setState(State state) {
        if (this.getState() == state) {
            return this;
        }
        return this.duplicateWithState(state);
    }

    protected abstract PropertyValue duplicateWithState(State var1);

    @Override
    public int compareTo(PropertyValue o) {
        int propertyDiff = this.getProperty().compareTo((OWLPrimitiveData)o.getProperty());
        if (propertyDiff != 0) {
            return propertyDiff;
        }
        int valueDiff = this.getValue().compareTo(o.getValue());
        return valueDiff;
    }

    @Nonnull
    public abstract PlainPropertyValue toPlainPropertyValue();
}

