/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import edu.stanford.protege.webprotege.entity.OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLLiteralData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.entity.OWLPropertyData;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.HasLang;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;

public class PropertyValueComparator
implements Comparator<PropertyValue> {
    public static final int AFTER = 1;
    public static final int BEFORE = -1;
    @Nonnull
    private final Comparator<? super OWLAnnotationProperty> annotationPropertyComparator;
    @Nonnull
    private final HasLang hasLang;

    @Inject
    public PropertyValueComparator(@Nonnull Comparator<? super OWLAnnotationProperty> annotationPropertyComparator, @Nonnull HasLang hasLang) {
        this.annotationPropertyComparator = annotationPropertyComparator;
        this.hasLang = hasLang;
    }

    @Override
    public int compare(PropertyValue o1, PropertyValue o2) {
        String prop2BrowserText;
        OWLPrimitiveData val1 = o1.getValue();
        OWLPrimitiveData val2 = o2.getValue();
        if (val1 instanceof OWLLiteralData && val2 instanceof OWLLiteralData) {
            OWLLiteralData lit1 = (OWLLiteralData)val1;
            OWLLiteralData lit2 = (OWLLiteralData)val2;
            if (lit1.hasLang() && lit2.hasLang()) {
                int langDelta;
                if (this.isDefaultLanguage(lit1)) {
                    if (!this.isDefaultLanguage(lit2)) {
                        return -1;
                    }
                } else if (this.isDefaultLanguage(lit2)) {
                    return 1;
                }
                if ((langDelta = lit1.getLang().compareToIgnoreCase(lit2.getLang())) != 0) {
                    return langDelta;
                }
            }
        }
        OWLPropertyData property1 = o1.getProperty();
        OWLPropertyData property2 = o2.getProperty();
        if (property1.isOWLAnnotationProperty()) {
            if (property2.isOWLAnnotationProperty()) {
                OWLAnnotationPropertyData annoProp1 = (OWLAnnotationPropertyData)property1;
                OWLAnnotationPropertyData annoProp2 = (OWLAnnotationPropertyData)property2;
                return this.annotationPropertyComparator.compare((OWLAnnotationProperty)annoProp1.getEntity(), (OWLAnnotationProperty)annoProp2.getEntity());
            }
            return -1;
        }
        if (property2.isOWLAnnotationProperty()) {
            return 1;
        }
        String prop1BrowserText = property1.getBrowserText();
        int delta = prop1BrowserText.compareToIgnoreCase(prop2BrowserText = property2.getBrowserText());
        if (delta != 0) {
            return delta;
        }
        String val1Rendering = val1.getBrowserText();
        String val2Rendering = val2.getBrowserText();
        return val1Rendering.compareToIgnoreCase(val2Rendering);
    }

    private boolean isDefaultLanguage(OWLLiteralData lit) {
        return lit.hasLang() && this.hasLang.getLang().equals(lit.getLang());
    }
}

