/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.HasLogicalPropertyValues;
import edu.stanford.protege.webprotege.frame.HasPropertyValues;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLEntity;

public class PropertyValueList
implements Serializable,
HasPropertyValues,
HasAnnotationPropertyValues,
HasLogicalPropertyValues {
    private ImmutableSet<PropertyValue> propertyValues;

    private PropertyValueList() {
    }

    public PropertyValueList(Collection<? extends PropertyValue> propertyValues) {
        this.propertyValues = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(propertyValues)));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.propertyValues});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyValueList)) {
            return false;
        }
        PropertyValueList other = (PropertyValueList)obj;
        return this.propertyValues.equals(other.propertyValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PropertyValueList").addValue(this.propertyValues).toString();
    }

    @Override
    public ImmutableSet<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return (ImmutableSet)this.propertyValues.stream().filter(PropertyValue::isAnnotation).map(pv -> (PropertyAnnotationValue)pv).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableList<PropertyValue> getLogicalPropertyValues() {
        return (ImmutableList)this.propertyValues.stream().filter(PropertyValue::isLogical).collect(ImmutableList.toImmutableList());
    }

    public Set<OWLEntity> getSignature() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        for (PropertyValue propertyValue : this.propertyValues) {
            result.addAll(propertyValue.getProperty().getSignature());
            if (propertyValue instanceof PropertyAnnotationValue) {
                Optional<OWLEntityData> entityValue = ((PropertyAnnotationValue)propertyValue).getValueAsEntity();
                if (!entityValue.isPresent()) continue;
                result.add(entityValue.get().getEntity());
                continue;
            }
            result.addAll(propertyValue.getValue().getSignature());
        }
        return result;
    }
}

