/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.data.FormData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class FormDataByFormId {
    private Map<FormId, FormData> map;

    public FormDataByFormId(Map<FormId, FormData> map) {
        this.map = new LinkedHashMap<FormId, FormData>((Map)Preconditions.checkNotNull(map));
    }

    private FormDataByFormId() {
    }

    @Nonnull
    public Collection<FormId> getFormIds() {
        return ImmutableSet.copyOf(this.map.keySet());
    }

    @Nonnull
    public Optional<FormData> getFormData(@Nonnull FormId formId) {
        return Optional.ofNullable(this.map.get(formId));
    }

    public boolean contains(FormId formId) {
        return this.map.containsKey(formId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormDataByFormId)) {
            return false;
        }
        FormDataByFormId that = (FormDataByFormId)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        return "FormDataByFormId{" + this.map + "}";
    }
}

