/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.FormSubjectFactoryDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormFieldDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormDescriptor {
    private final List<FormFieldDescriptor> elements;
    private FormId formId;
    private LanguageMap label = LanguageMap.empty();
    @Nullable
    private FormSubjectFactoryDescriptor subjectFactoryDescriptor;

    private FormDescriptor() {
        this.elements = new ArrayList<FormFieldDescriptor>();
    }

    @JsonCreator
    public FormDescriptor(@JsonProperty(value="id") FormId id, @JsonProperty(value="label") LanguageMap label, @JsonProperty(value="fields") List<FormFieldDescriptor> formFieldDescriptors, @JsonProperty(value="subjectFactoryDescriptor") Optional<FormSubjectFactoryDescriptor> subjectFactoryDescriptor) {
        this.formId = id;
        this.label = label;
        this.elements = new ArrayList<FormFieldDescriptor>(formFieldDescriptors);
        this.subjectFactoryDescriptor = subjectFactoryDescriptor.orElse(null);
    }

    public static FormDescriptor empty(FormId formId) {
        return new FormDescriptor(formId, LanguageMap.empty(), Collections.emptyList(), Optional.empty());
    }

    public static Builder builder(FormId formId) {
        return new Builder(formId);
    }

    public FormDescriptor withFields(Predicate<FormFieldDescriptor> test) {
        List<FormFieldDescriptor> filteredFields = this.elements.stream().filter(test).collect(Collectors.toList());
        return new FormDescriptor(this.formId, this.label, filteredFields, this.getSubjectFactoryDescriptor());
    }

    public FormId getFormId() {
        return this.formId;
    }

    public LanguageMap getLabel() {
        return this.label;
    }

    @Nonnull
    public Optional<FormSubjectFactoryDescriptor> getSubjectFactoryDescriptor() {
        return Optional.ofNullable(this.subjectFactoryDescriptor);
    }

    public List<FormFieldDescriptor> getFields() {
        return this.elements;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.formId, this.label, this.elements});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormDescriptor)) {
            return false;
        }
        FormDescriptor other = (FormDescriptor)obj;
        return this.formId.equals(other.formId) && this.label.equals(other.label) && this.elements.equals(other.elements) && Objects.equal((Object)this.subjectFactoryDescriptor, (Object)other.subjectFactoryDescriptor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormDescriptor").addValue((Object)this.formId).addValue((Object)this.label).addValue(this.elements).toString();
    }

    @Nonnull
    public FormDescriptor withFormId(@Nonnull FormId formId) {
        return new FormDescriptor(formId, this.label, this.getFields(), this.getSubjectFactoryDescriptor());
    }

    @Nonnull
    public FormDescriptor withLabel(@Nonnull LanguageMap newLabel) {
        return new FormDescriptor(this.formId, newLabel, this.getFields(), this.getSubjectFactoryDescriptor());
    }

    public static class Builder {
        private final FormId formId;
        private final List<FormFieldDescriptor> builder_elementDescriptors = new ArrayList<FormFieldDescriptor>();
        private LanguageMap label = LanguageMap.empty();

        public Builder(FormId formId) {
            this.formId = (FormId)Preconditions.checkNotNull((Object)formId);
        }

        public Builder setLabel(LanguageMap label) {
            this.label = (LanguageMap)Preconditions.checkNotNull((Object)label);
            return this;
        }

        public Builder addDescriptor(FormFieldDescriptor descriptor) {
            this.builder_elementDescriptors.add(descriptor);
            return this;
        }

        public FormDescriptor build() {
            return new FormDescriptor(this.formId, this.label, this.builder_elementDescriptors, Optional.empty());
        }
    }
}

