/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.forms.AutoValue_FormDescriptorRecord;
import edu.stanford.protege.webprotege.forms.FormDescriptor;
import edu.stanford.protege.webprotege.forms.FormId;
import java.util.Comparator;
import javax.annotation.Nonnull;

@AutoValue
public abstract class FormDescriptorRecord
implements Comparable<FormDescriptorRecord> {
    public static final String PROJECT_ID = "projectId";
    public static final String FORM_DESCRIPTOR = "formDescriptor";
    public static final String ORDINAL = "ordinal";
    private static final Comparator<FormDescriptorRecord> comparingByOrdinal = Comparator.comparing(FormDescriptorRecord::getOrdinal);

    @JsonCreator
    public static FormDescriptorRecord get(@JsonProperty(value="projectId") @Nonnull ProjectId projectId, @JsonProperty(value="formDescriptor") FormDescriptor formDescriptor, @JsonProperty(value="ordinal") Integer ordinal) {
        return new AutoValue_FormDescriptorRecord(projectId, formDescriptor == null ? FormDescriptor.empty(FormId.generate()) : formDescriptor, ordinal == null ? 0 : ordinal);
    }

    @JsonProperty(value="projectId")
    @Nonnull
    public abstract ProjectId getProjectId();

    @JsonProperty(value="formDescriptor")
    @Nonnull
    public abstract FormDescriptor getFormDescriptor();

    @JsonProperty(value="ordinal")
    @Nonnull
    public abstract Integer getOrdinal();

    @Override
    public int compareTo(@Nonnull FormDescriptorRecord o) {
        return comparingByOrdinal.compare(this, o);
    }
}

