/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.PageRequest;
import edu.stanford.protege.webprotege.forms.AutoValue_FormPageRequestIndex_Key;
import edu.stanford.protege.webprotege.forms.FormPageRequest;
import edu.stanford.protege.webprotege.forms.data.FormSubject;
import edu.stanford.protege.webprotege.forms.field.FormRegionId;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class FormPageRequestIndex {
    @Nonnull
    private final ImmutableMap<Key, FormPageRequest> indexMap;

    public FormPageRequestIndex(@Nonnull ImmutableMap<Key, FormPageRequest> indexMap) {
        this.indexMap = (ImmutableMap)Preconditions.checkNotNull(indexMap);
    }

    @Nonnull
    public static FormPageRequestIndex create(@Nonnull ImmutableList<FormPageRequest> pageRequests) {
        Preconditions.checkNotNull(pageRequests);
        HashMap<Key, FormPageRequest> map = new HashMap<Key, FormPageRequest>();
        for (FormPageRequest pageRequest : pageRequests) {
            map.put(Key.get(pageRequest.getSubject(), pageRequest.getFieldId(), pageRequest.getSourceType()), pageRequest);
        }
        return new FormPageRequestIndex((ImmutableMap<Key, FormPageRequest>)ImmutableMap.copyOf(map));
    }

    @Nonnull
    public PageRequest getPageRequest(FormSubject formSubject, FormRegionId id, FormPageRequest.SourceType sourceType) {
        FormPageRequest formPageRequest = (FormPageRequest)this.indexMap.get((Object)Key.get(formSubject, id, sourceType));
        if (formPageRequest != null) {
            return formPageRequest.getPageRequest();
        }
        return PageRequest.requestPageWithSize((int)1, (int)10);
    }

    @AutoValue
    public static abstract class Key {
        public static Key get(@Nonnull FormSubject subject, @Nonnull FormRegionId formRegionId, @Nonnull FormPageRequest.SourceType sourceType) {
            return new AutoValue_FormPageRequestIndex_Key(subject, formRegionId, sourceType);
        }

        @Nonnull
        public abstract FormSubject getFormSubject();

        @Nonnull
        public abstract FormRegionId getFormRegionId();

        @Nonnull
        public abstract FormPageRequest.SourceType getSourceType();
    }
}

