/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.forms.data.AutoValue_TextControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDtoVisitorEx;
import edu.stanford.protege.webprotege.forms.data.TextControlData;
import edu.stanford.protege.webprotege.forms.field.TextControlDescriptor;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLLiteral;

@JsonTypeName(value="TextControlDataDto")
@AutoValue
public abstract class TextControlDataDto
implements FormControlDataDto,
Comparable<TextControlDataDto> {
    private static final Comparator<OWLLiteral> literalComparator = Comparator.nullsLast(Comparator.comparing(OWLLiteral::getLang).thenComparing(OWLLiteral::getLiteral, String::compareToIgnoreCase).thenComparing(OWLLiteral::getDatatype));

    @JsonCreator
    @Nonnull
    public static TextControlDataDto get(@JsonProperty(value="descriptor") @Nonnull TextControlDescriptor descriptor, @JsonProperty(value="value") @Nonnull OWLLiteral value, @JsonProperty(value="depth") int depth) {
        return new AutoValue_TextControlDataDto(depth, descriptor, value);
    }

    @JsonProperty(value="descriptor")
    @Nonnull
    public abstract TextControlDescriptor getDescriptor();

    @JsonProperty(value="value")
    @Nullable
    protected abstract OWLLiteral getValueInternal();

    @JsonIgnore
    @Nonnull
    public Optional<OWLLiteral> getValue() {
        return Optional.ofNullable(this.getValueInternal());
    }

    @Override
    public <R> R accept(FormControlDataDtoVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public TextControlData toFormControlData() {
        return TextControlData.get(this.getDescriptor(), this.getValueInternal());
    }

    @Override
    public int compareTo(@Nonnull TextControlDataDto o) {
        return literalComparator.compare(this.getValueInternal(), o.getValueInternal());
    }
}

