/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.forms.field.FormFieldDescriptor;
import java.io.Serializable;

public class CompositeFieldDescriptorEntry
implements Serializable {
    private FormFieldDescriptor descriptor;
    private double flexBasis;
    private double flexGrow;
    private double flexShrink;

    private CompositeFieldDescriptorEntry() {
    }

    public CompositeFieldDescriptorEntry(double flexGrow, double flexShrink, FormFieldDescriptor descriptor, double flexBasis) {
        this.descriptor = (FormFieldDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.flexGrow = flexGrow;
        this.flexShrink = flexShrink;
        this.flexBasis = flexBasis;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompositeFieldDescriptorEntry)) {
            return false;
        }
        CompositeFieldDescriptorEntry other = (CompositeFieldDescriptorEntry)obj;
        return this.descriptor.equals(other.descriptor) && this.flexBasis == other.flexBasis && this.flexGrow == other.flexGrow && this.flexShrink == other.flexShrink;
    }

    public double getBasis() {
        return this.flexBasis;
    }

    @JsonUnwrapped
    public FormFieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public double getFlexGrow() {
        return this.flexGrow;
    }

    public double getFlexShrink() {
        return this.flexShrink;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.descriptor, this.flexBasis, this.flexGrow, this.flexShrink});
    }
}

