/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.forms.FormSubjectFactoryDescriptor;
import edu.stanford.protege.webprotege.forms.field.AutoValue_GridControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorDtoVisitor;
import edu.stanford.protege.webprotege.forms.field.GridColumnDescriptor;
import edu.stanford.protege.webprotege.forms.field.GridColumnDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.GridColumnId;
import edu.stanford.protege.webprotege.forms.field.GridControlDescriptor;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonTypeName(value="GridControlDescriptorDto")
@AutoValue
public abstract class GridControlDescriptorDto
implements FormControlDescriptorDto {
    @JsonCreator
    @Nonnull
    public static GridControlDescriptorDto get(@JsonProperty(value="columns") @Nonnull ImmutableList<GridColumnDescriptorDto> columns, @JsonProperty(value="formSubjectFactoryDescriptor") @Nullable FormSubjectFactoryDescriptor formSubjectFactoryDescriptor) {
        return new AutoValue_GridControlDescriptorDto(columns, formSubjectFactoryDescriptor);
    }

    @Nonnull
    public abstract ImmutableList<GridColumnDescriptorDto> getColumns();

    @Nullable
    protected abstract FormSubjectFactoryDescriptor getSubjectFactoryDescriptorInternal();

    @Nonnull
    public Optional<FormSubjectFactoryDescriptor> getSubjectFactoryDescriptor() {
        return Optional.ofNullable(this.getSubjectFactoryDescriptorInternal());
    }

    @Override
    public <R> R accept(FormControlDescriptorDtoVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public GridControlDescriptor toFormControlDescriptor() {
        return GridControlDescriptor.get((ImmutableList<GridColumnDescriptor>)((ImmutableList)this.getColumns().stream().map(GridColumnDescriptorDto::toGridColumnDescriptor).collect(ImmutableList.toImmutableList())), this.getSubjectFactoryDescriptorInternal());
    }

    public int getNestedColumnCount() {
        int count = 0;
        for (GridColumnDescriptorDto columnDescriptor : this.getColumns()) {
            count += columnDescriptor.getNestedColumnCount();
        }
        return count;
    }

    @JsonIgnore
    @Nonnull
    public Stream<GridColumnDescriptorDto> getLeafColumns() {
        return this.getColumns().stream().flatMap(GridColumnDescriptorDto::getLeafColumnDescriptors);
    }

    @JsonIgnore
    public ImmutableMap<GridColumnId, GridColumnId> getLeafColumnToTopLevelColumnMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getColumns().forEach(topLevelColumn -> topLevelColumn.getLeafColumnDescriptors().map(GridColumnDescriptorDto::getId).forEach(leafColumnId -> builder.put(leafColumnId, (Object)topLevelColumn.getId())));
        return builder.build();
    }

    @JsonIgnore
    public int getColumnIndex(GridColumnId columnId) {
        ImmutableList<GridColumnDescriptorDto> columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((GridColumnDescriptorDto)columns.get(i)).getId().equals(columnId)) continue;
            return i;
        }
        return -1;
    }
}

