/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorVisitor;
import edu.stanford.protege.webprotege.forms.field.NumberControlRange;
import edu.stanford.protege.webprotege.forms.field.NumberControlType;
import javax.annotation.Nonnull;

@JsonTypeName(value="NUMBER")
public class NumberControlDescriptor
implements FormControlDescriptor {
    protected static final String TYPE = "NUMBER";
    @Nonnull
    private String format = "#.#";
    private int length = 6;
    private LanguageMap placeholder = LanguageMap.empty();
    @Nonnull
    private NumberControlRange range = NumberControlRange.range(Double.MIN_VALUE, NumberControlRange.BoundType.INCLUSIVE, Double.MAX_VALUE, NumberControlRange.BoundType.INCLUSIVE);
    @Nonnull
    private NumberControlType widgetType = NumberControlType.PLAIN;

    private NumberControlDescriptor() {
    }

    public NumberControlDescriptor(@Nonnull String format, @Nonnull NumberControlRange range, @Nonnull NumberControlType widgetType, int length, @Nonnull LanguageMap placeholder) {
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.range = (NumberControlRange)Preconditions.checkNotNull((Object)range);
        this.widgetType = (NumberControlType)((Object)Preconditions.checkNotNull((Object)((Object)widgetType)));
        this.length = length;
        this.placeholder = (LanguageMap)Preconditions.checkNotNull((Object)placeholder);
    }

    public static String getTypeId() {
        return TYPE;
    }

    @Override
    public <R> R accept(@Nonnull FormControlDescriptorVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberControlDescriptor)) {
            return false;
        }
        NumberControlDescriptor other = (NumberControlDescriptor)obj;
        return this.format.equals(other.format) && this.range.equals(other.range) && this.widgetType.equals((Object)other.widgetType) && this.length == other.length && this.placeholder.equals(other.placeholder);
    }

    @Override
    @Nonnull
    public String getAssociatedType() {
        return TYPE;
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    public int getLength() {
        return this.length;
    }

    public LanguageMap getPlaceholder() {
        return this.placeholder;
    }

    @Nonnull
    public NumberControlRange getRange() {
        return this.range;
    }

    @Nonnull
    public NumberControlType getWidgetType() {
        return this.widgetType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.format, this.range, this.widgetType, this.length, this.placeholder});
    }
}

