/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData;
import java.io.IOException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class FormControlValueDeserializer
extends StdDeserializer<PrimitiveFormControlData> {
    private final OWLDataFactory dataFactory;

    public FormControlValueDeserializer(OWLDataFactory dataFactory) {
        super(PrimitiveFormControlData.class);
        this.dataFactory = dataFactory;
    }

    public PrimitiveFormControlData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.isTextual()) {
            return PrimitiveFormControlData.get(node.asText());
        }
        if (node.isNumber()) {
            return PrimitiveFormControlData.get(node.asDouble());
        }
        if (node.isBoolean()) {
            return PrimitiveFormControlData.get(node.asBoolean());
        }
        if (node.isObject()) {
            if (node.has("iri")) {
                if (node.has("type")) {
                    String type;
                    IRI iri = IRI.create((String)node.get("iri").asText());
                    switch (type = node.get("type").asText()) {
                        case "owl:Class": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLClass(iri));
                        }
                        case "owl:ObjectProperty": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLObjectProperty(iri));
                        }
                        case "owl:DatatypeProperty": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLDataProperty(iri));
                        }
                        case "owl:AnnotationProperty": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLAnnotationProperty(iri));
                        }
                        case "rdfs:Datatype": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLDatatype(iri));
                        }
                        case "owl:NamedIndividual": {
                            return PrimitiveFormControlData.get((OWLEntity)this.dataFactory.getOWLNamedIndividual(iri));
                        }
                    }
                    throw new JsonParseException(p, "Unrecognised term type: " + type);
                }
                return PrimitiveFormControlData.get(IRI.create((String)node.get("iri").asText()));
            }
            if (node.has("value") || node.has("literal")) {
                JsonNode literalNode = node.get("value");
                if (literalNode == null) {
                    literalNode = node.get("literal");
                }
                String literal = literalNode.asText();
                JsonNode langNode = node.get("lang");
                JsonNode typeNode = node.get("type");
                if (typeNode != null && !typeNode.asText().equals(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI().toString())) {
                    return PrimitiveFormControlData.get(this.dataFactory.getOWLLiteral(literal, this.dataFactory.getOWLDatatype(IRI.create((String)typeNode.asText()))));
                }
                return PrimitiveFormControlData.get(this.dataFactory.getOWLLiteral(literal, langNode.asText("")));
            }
        }
        throw new JsonParseException(p, "Cannot parse node as primitive value");
    }
}

