/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.AutoValue_FormDescriptorDto;
import edu.stanford.protege.webprotege.forms.FormDescriptor;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.FormSubjectFactoryDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormFieldDescriptorDto;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class FormDescriptorDto {
    @JsonCreator
    public static FormDescriptorDto get(@JsonProperty(value="formId") @Nonnull FormId formId, @JsonProperty(value="label") @Nonnull LanguageMap label, @JsonProperty(value="fields") @Nonnull ImmutableList<FormFieldDescriptorDto> fields, @JsonProperty(value="formSubjectFactoryDescriptor") @Nullable FormSubjectFactoryDescriptor subjectFactoryDescriptor) {
        return new AutoValue_FormDescriptorDto(formId, label, fields, subjectFactoryDescriptor);
    }

    @Nonnull
    public abstract FormId getFormId();

    @Nonnull
    public abstract LanguageMap getLabel();

    @Nonnull
    public abstract ImmutableList<FormFieldDescriptorDto> getFields();

    @Nullable
    protected abstract FormSubjectFactoryDescriptor getFormSubjectFactoryDescriptorInternal();

    public Optional<FormSubjectFactoryDescriptor> getFormSubjectFactoryDescriptor() {
        return Optional.ofNullable(this.getFormSubjectFactoryDescriptorInternal());
    }

    @Nonnull
    public FormDescriptor toFormDescriptor() {
        return new FormDescriptor(this.getFormId(), this.getLabel(), (List)this.getFields().stream().map(FormFieldDescriptorDto::toFormFieldDescriptor).collect(ImmutableList.toImmutableList()), this.getFormSubjectFactoryDescriptor());
    }
}

