/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.forms.data.AutoValue_LiteralFormControlData;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlDataProxy;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLPrimitive;

@AutoValue
public abstract class LiteralFormControlData
implements PrimitiveFormControlData {
    public static LiteralFormControlData get(@Nonnull OWLLiteral literal) {
        return new AutoValue_LiteralFormControlData(literal);
    }

    @JsonValue
    @Nonnull
    public abstract OWLLiteral getLiteral();

    @JsonIgnore
    public double getValueAsDouble() {
        String lexicalForm = this.getLiteral().getLiteral();
        return Double.parseDouble(lexicalForm);
    }

    @JsonIgnore
    public boolean isNumber() {
        OWLDatatype datatype = this.getLiteral().getDatatype();
        if (!datatype.isBuiltIn()) {
            return false;
        }
        return datatype.getBuiltInDatatype().isNumeric();
    }

    @Override
    @Nonnull
    public Optional<OWLEntity> asEntity() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<IRI> asIri() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of(this.getLiteral());
    }

    @Override
    @Nonnull
    public OWLPrimitive getPrimitive() {
        return this.getLiteral();
    }

    @Override
    public PrimitiveFormControlDataProxy toPrimitiveFormControlDataProxy() {
        String dt = null;
        if (!this.getLiteral().getDatatype().isRDFPlainLiteral()) {
            dt = this.getLiteral().getDatatype().getIRI().toString();
        }
        String lang = null;
        if (!this.getLiteral().getLang().isEmpty()) {
            lang = this.getLiteral().getLang();
        }
        return new PrimitiveFormControlDataProxy(null, null, this.getLiteral().getLiteral(), dt, lang);
    }
}

