/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.stanford.protege.webprotege.forms.data.EntityFormControlData;
import edu.stanford.protege.webprotege.forms.data.IriFormControlData;
import edu.stanford.protege.webprotege.forms.data.LiteralFormControlData;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData2ProxyConverter;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlDataProxy;
import edu.stanford.protege.webprotege.forms.data.Proxy2PrimitiveFormControlDataConverter;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplBoolean;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplString;

@JsonSerialize(converter=PrimitiveFormControlData2ProxyConverter.class)
@JsonDeserialize(converter=Proxy2PrimitiveFormControlDataConverter.class)
public interface PrimitiveFormControlData {
    public static PrimitiveFormControlData get(OWLEntity entity) {
        return EntityFormControlData.get(entity);
    }

    public static PrimitiveFormControlData get(IRI iri) {
        return IriFormControlData.get(iri);
    }

    public static PrimitiveFormControlData get(OWLLiteral literal) {
        return LiteralFormControlData.get(literal);
    }

    public static PrimitiveFormControlData get(String text) {
        return LiteralFormControlData.get((OWLLiteral)new OWLLiteralImplString(text));
    }

    public static PrimitiveFormControlData get(double value) {
        return LiteralFormControlData.get((OWLLiteral)new OWLLiteralImplDouble(value, (OWLDatatype)new OWL2DatatypeImpl(OWL2Datatype.XSD_DECIMAL)));
    }

    public static PrimitiveFormControlData get(boolean value) {
        return LiteralFormControlData.get((OWLLiteral)new OWLLiteralImplBoolean(value, (OWLDatatype)new OWL2DatatypeImpl(OWL2Datatype.XSD_BOOLEAN)));
    }

    @Nonnull
    public Optional<OWLEntity> asEntity();

    @Nonnull
    public Optional<IRI> asIri();

    @Nonnull
    public Optional<OWLLiteral> asLiteral();

    @Nonnull
    public OWLPrimitive getPrimitive();

    public PrimitiveFormControlDataProxy toPrimitiveFormControlDataProxy();
}

