/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.ExpansionState;
import edu.stanford.protege.webprotege.forms.HasFormFieldId;
import edu.stanford.protege.webprotege.forms.field.AutoValue_FormFieldDescriptor;
import edu.stanford.protege.webprotege.forms.field.BoundControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FieldRun;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormFieldDeprecationStrategy;
import edu.stanford.protege.webprotege.forms.field.FormFieldId;
import edu.stanford.protege.webprotege.forms.field.HasRepeatability;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import edu.stanford.protege.webprotege.forms.field.SubFormControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "owlBinding", "label", "fieldRun", "formControlDescriptor", "repeatability", "optionality", "readOnly", "help"})
@AutoValue
public abstract class FormFieldDescriptor
implements HasFormFieldId,
HasRepeatability,
BoundControlDescriptor {
    public static final String ID = "id";
    public static final String OWL_BINDING = "owlBinding";
    public static final String LABEL = "label";
    public static final String FIELD_RUN = "fieldRun";
    public static final String FORM_CONTROL_DESCRIPTOR = "formControlDescriptor";
    public static final String REPEATABILITY = "repeatability";
    public static final String OPTIONALITY = "optionality";
    public static final String READ_ONLY = "readOnly";
    public static final String INITIAL_EXPANSIONS_STATE = "initialExpansionState";
    public static final String HELP = "help";
    public static final String DEPRECATION_STRATEGY = "deprecationStrategy";

    @Nonnull
    public static FormFieldDescriptor get(@Nonnull FormFieldId id, @Nullable OwlBinding owlBinding, @Nullable LanguageMap formLabel, @Nullable FieldRun fieldRun, @Nullable FormFieldDeprecationStrategy deprecationStrategy, @Nonnull FormControlDescriptor fieldDescriptor, Repeatability repeatability, Optionality optionality, boolean readOnly, @Nullable ExpansionState expansionState, @Nullable LanguageMap help) {
        return new AutoValue_FormFieldDescriptor(id, owlBinding, formLabel == null ? LanguageMap.empty() : formLabel, fieldRun == null ? FieldRun.START : fieldRun, fieldDescriptor, optionality == null ? Optionality.REQUIRED : optionality, repeatability == null ? Repeatability.NON_REPEATABLE : repeatability, deprecationStrategy == null ? FormFieldDeprecationStrategy.DELETE_VALUES : deprecationStrategy, readOnly, expansionState == null ? ExpansionState.EXPANDED : expansionState, help == null ? LanguageMap.empty() : help);
    }

    @JsonCreator
    @Nonnull
    public static FormFieldDescriptor getFromJson(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="owlBinding") @Nullable OwlBinding owlBinding, @JsonProperty(value="label") @Nullable LanguageMap formLabel, @JsonProperty(value="fieldRun") @Nullable FieldRun fieldRun, @JsonProperty(value="deprecationStrategy") @Nullable FormFieldDeprecationStrategy deprecationStrategy, @JsonProperty(value="formControlDescriptor") @Nonnull FormControlDescriptor fieldDescriptor, @JsonProperty(value="repeatability") @Nullable Repeatability repeatability, @JsonProperty(value="optionality") @Nullable Optionality optionality, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="initialExpansionState") @Nullable ExpansionState expansionState, @JsonProperty(value="help") @Nullable LanguageMap help) {
        FormFieldId formFieldId = FormFieldId.get((String)Preconditions.checkNotNull((Object)id));
        return FormFieldDescriptor.get(formFieldId, owlBinding, formLabel, fieldRun, deprecationStrategy, fieldDescriptor, repeatability, optionality, readOnly, expansionState, help);
    }

    @Override
    @Nonnull
    @JsonIgnore
    public abstract FormFieldId getId();

    @JsonProperty(value="id")
    protected String getFormFieldId() {
        return this.getId().getId();
    }

    @JsonIgnore
    @Nullable
    protected abstract OwlBinding getOwlBindingInternal();

    @Override
    @Nonnull
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    public abstract LanguageMap getLabel();

    @Nonnull
    public abstract FieldRun getFieldRun();

    @Override
    @Nonnull
    public abstract FormControlDescriptor getFormControlDescriptor();

    @Nonnull
    public abstract Optionality getOptionality();

    @Override
    @Nonnull
    public abstract Repeatability getRepeatability();

    @JsonProperty(value="deprecationStrategy")
    @Nonnull
    public abstract FormFieldDeprecationStrategy getDeprecationStrategy();

    public abstract boolean isReadOnly();

    @JsonProperty(value="initialExpansionState")
    @Nonnull
    public abstract ExpansionState getInitialExpansionState();

    @Nonnull
    public abstract LanguageMap getHelp();

    @JsonIgnore
    public boolean isComposite() {
        return this.getFormControlDescriptor() instanceof SubFormControlDescriptor;
    }
}

