/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.ExpansionState;
import edu.stanford.protege.webprotege.forms.HasFormFieldId;
import edu.stanford.protege.webprotege.forms.field.AutoValue_FormFieldDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FieldRun;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormFieldDeprecationStrategy;
import edu.stanford.protege.webprotege.forms.field.FormFieldDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormFieldId;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import edu.stanford.protege.webprotege.forms.field.SubFormControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class FormFieldDescriptorDto
implements HasFormFieldId {
    @JsonCreator
    @Nonnull
    public static FormFieldDescriptorDto get(@JsonProperty(value="id") FormFieldId formFieldId, @JsonProperty(value="owlBinding") OwlBinding owlBinding, @JsonProperty(value="label") LanguageMap newlabel, @JsonProperty(value="fieldRun") FieldRun fieldRun, @JsonProperty(value="formControlDescriptor") FormControlDescriptorDto descriptorDto, @JsonProperty(value="optionality") Optionality optionality, @JsonProperty(value="repeatability") Repeatability repeatability, @JsonProperty(value="deprecationStrategy") FormFieldDeprecationStrategy deprecationStrategy, @JsonProperty(value="readOnly") boolean newReadOnly, @JsonProperty(value="initialExpansionState") ExpansionState initialExpansionState, @JsonProperty(value="help") LanguageMap help) {
        return new AutoValue_FormFieldDescriptorDto(formFieldId, owlBinding, newlabel, fieldRun, descriptorDto, optionality, repeatability, deprecationStrategy, newReadOnly, initialExpansionState, help);
    }

    @Override
    @Nonnull
    @JsonProperty(value="id")
    public abstract FormFieldId getId();

    @JsonIgnore
    @Nullable
    protected abstract OwlBinding getOwlBindingInternal();

    @Nonnull
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    public abstract LanguageMap getLabel();

    @Nonnull
    public abstract FieldRun getFieldRun();

    @Nonnull
    public abstract FormControlDescriptorDto getFormControlDescriptor();

    @Nonnull
    public abstract Optionality getOptionality();

    @Nonnull
    public abstract Repeatability getRepeatability();

    @Nonnull
    public abstract FormFieldDeprecationStrategy getDeprecationStrategy();

    public abstract boolean isReadOnly();

    @Nonnull
    public abstract ExpansionState getInitialExpansionState();

    @Nonnull
    public abstract LanguageMap getHelp();

    @JsonIgnore
    public boolean isComposite() {
        return this.getFormControlDescriptor() instanceof SubFormControlDescriptor;
    }

    public FormFieldDescriptor toFormFieldDescriptor() {
        return FormFieldDescriptor.get(this.getId(), this.getOwlBindingInternal(), this.getLabel(), this.getFieldRun(), this.getDeprecationStrategy(), this.getFormControlDescriptor().toFormControlDescriptor(), this.getRepeatability(), this.getOptionality(), this.isReadOnly(), this.getInitialExpansionState(), this.getHelp());
    }
}

