/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.field.AutoValue_GridColumnDescriptor;
import edu.stanford.protege.webprotege.forms.field.BoundControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.GridColumnId;
import edu.stanford.protege.webprotege.forms.field.GridControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class GridColumnDescriptor
implements BoundControlDescriptor {
    @Nonnull
    public static GridColumnDescriptor get(@Nonnull GridColumnId id, @Nullable Optionality optionality, @Nullable Repeatability repeatability, @Nullable OwlBinding owlBinding, @Nonnull LanguageMap columnLabel, @Nonnull FormControlDescriptor formControlDescriptor) {
        return new AutoValue_GridColumnDescriptor(id, optionality == null ? Optionality.REQUIRED : optionality, repeatability == null ? Repeatability.NON_REPEATABLE : repeatability, owlBinding, columnLabel, formControlDescriptor);
    }

    @JsonCreator
    @Nonnull
    public static GridColumnDescriptor get(@Nonnull @JsonProperty(value="id") String id, @Nullable @JsonProperty(value="optionality") Optionality optionality, @Nullable @JsonProperty(value="repeatability") Repeatability repeatability, @Nullable @JsonProperty(value="owlBinding") OwlBinding owlBinding, @Nonnull @JsonProperty(value="label") LanguageMap columnLabel, @Nonnull @JsonProperty(value="formControlDescriptor") FormControlDescriptor formControlDescriptor) {
        return new AutoValue_GridColumnDescriptor(GridColumnId.get(id), optionality == null ? Optionality.REQUIRED : optionality, repeatability == null ? Repeatability.NON_REPEATABLE : repeatability, owlBinding, columnLabel, formControlDescriptor);
    }

    @JsonIgnore
    @Nonnull
    public abstract GridColumnId getId();

    @JsonProperty(value="id")
    public String getGridColumnId() {
        return this.getId().getId();
    }

    @JsonIgnore
    public Stream<GridColumnDescriptor> getLeafColumnDescriptors() {
        FormControlDescriptor formControlDescriptor = this.getFormControlDescriptor();
        if (formControlDescriptor instanceof GridControlDescriptor) {
            return ((GridControlDescriptor)formControlDescriptor).getLeafColumns();
        }
        return Stream.of(this);
    }

    @JsonIgnore
    public Stream<GridColumnId> getLeafColumnIds() {
        return this.getLeafColumnDescriptors().map(GridColumnDescriptor::getId);
    }

    @JsonIgnore
    public boolean isLeafColumnDescriptor() {
        return !(this.getFormControlDescriptor() instanceof GridControlDescriptor);
    }

    @Nonnull
    public abstract Optionality getOptionality();

    @Nonnull
    public abstract Repeatability getRepeatability();

    @JsonIgnore
    @Nullable
    protected abstract OwlBinding getOwlBindingInternal();

    @Override
    @Nonnull
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    public abstract LanguageMap getLabel();

    @Override
    @Nonnull
    public abstract FormControlDescriptor getFormControlDescriptor();

    @JsonIgnore
    public int getNestedColumnCount() {
        FormControlDescriptor formControlDescriptor = this.getFormControlDescriptor();
        if (formControlDescriptor instanceof GridControlDescriptor) {
            return ((GridControlDescriptor)this.getFormControlDescriptor()).getNestedColumnCount();
        }
        return 1;
    }

    @JsonIgnore
    public boolean isRepeatable() {
        return this.getRepeatability().isRepeatable();
    }
}

