/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.forms.FormSubjectFactoryDescriptor;
import edu.stanford.protege.webprotege.forms.field.AutoValue_GridControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorVisitor;
import edu.stanford.protege.webprotege.forms.field.GridColumnDescriptor;
import edu.stanford.protege.webprotege.forms.field.GridColumnId;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;

@JsonTypeName(value="GRID")
@AutoValue
public abstract class GridControlDescriptor
implements FormControlDescriptor {
    protected static final String TYPE = "GRID";

    public static String getType() {
        return TYPE;
    }

    @JsonCreator
    @Nonnull
    public static GridControlDescriptor get(@Nonnull @JsonProperty(value="columns") ImmutableList<GridColumnDescriptor> columnDescriptors, @Nullable @JsonProperty(value="subjectFactoryDescriptor") FormSubjectFactoryDescriptor subjectFactoryDescriptor) {
        return new AutoValue_GridControlDescriptor(columnDescriptors == null ? ImmutableList.of() : columnDescriptors, subjectFactoryDescriptor == null ? FormSubjectFactoryDescriptor.get(EntityType.CLASS, null, Optional.empty()) : subjectFactoryDescriptor);
    }

    @Override
    @Nonnull
    public String getAssociatedType() {
        return GridControlDescriptor.getType();
    }

    @JsonProperty(value="columns")
    @Nonnull
    public abstract ImmutableList<GridColumnDescriptor> getColumns();

    @Override
    public <R> R accept(@Nonnull FormControlDescriptorVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @JsonIgnore
    public int getNestedColumnCount() {
        int count = 0;
        for (GridColumnDescriptor columnDescriptor : this.getColumns()) {
            count += columnDescriptor.getNestedColumnCount();
        }
        return count;
    }

    @JsonIgnore
    @Nullable
    protected abstract FormSubjectFactoryDescriptor getSubjectFactoryDescriptorInternal();

    public Optional<FormSubjectFactoryDescriptor> getSubjectFactoryDescriptor() {
        return Optional.ofNullable(this.getSubjectFactoryDescriptorInternal());
    }

    @JsonIgnore
    @Nonnull
    public Stream<GridColumnDescriptor> getLeafColumns() {
        return this.getColumns().stream().flatMap(GridColumnDescriptor::getLeafColumnDescriptors);
    }

    @JsonIgnore
    public ImmutableMap<GridColumnId, GridColumnId> getLeafColumnToTopLevelColumnMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getColumns().forEach(topLevelColumn -> topLevelColumn.getLeafColumnDescriptors().map(GridColumnDescriptor::getId).forEach(leafColumnId -> builder.put(leafColumnId, (Object)topLevelColumn.getId())));
        return builder.build();
    }

    @JsonIgnore
    public int getColumnIndex(GridColumnId columnId) {
        ImmutableList<GridColumnDescriptor> columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((GridColumnDescriptor)columns.get(i)).getId().equals(columnId)) continue;
            return i;
        }
        return -1;
    }
}

