/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorVisitor;
import edu.stanford.protege.webprotege.forms.field.LineMode;
import edu.stanford.protege.webprotege.forms.field.StringType;
import javax.annotation.Nonnull;

@JsonTypeName(value="TEXT")
public class TextControlDescriptor
implements FormControlDescriptor {
    protected static final String TYPE = "TEXT";
    private LanguageMap placeholder = LanguageMap.empty();
    private StringType stringType = StringType.SIMPLE_STRING;
    private LineMode lineMode = LineMode.SINGLE_LINE;
    private String pattern = "";
    private LanguageMap patternViolationErrorMessage = LanguageMap.empty();
    private String specificLangTag = "";

    private TextControlDescriptor() {
    }

    public TextControlDescriptor(@Nonnull LanguageMap placeholder, @Nonnull StringType stringType, @Nonnull String specificLangTag, @Nonnull LineMode lineMode, @Nonnull String pattern, @Nonnull LanguageMap patternViolationErrorMessage) {
        this.placeholder = (LanguageMap)Preconditions.checkNotNull((Object)placeholder);
        this.stringType = (StringType)((Object)Preconditions.checkNotNull((Object)((Object)stringType)));
        this.specificLangTag = (String)Preconditions.checkNotNull((Object)specificLangTag);
        this.lineMode = (LineMode)((Object)Preconditions.checkNotNull((Object)((Object)lineMode)));
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern);
        this.patternViolationErrorMessage = (LanguageMap)Preconditions.checkNotNull((Object)patternViolationErrorMessage);
    }

    @Nonnull
    public static String getType() {
        return TYPE;
    }

    public static TextControlDescriptor getDefault() {
        return new TextControlDescriptor(LanguageMap.empty(), StringType.SIMPLE_STRING, "", LineMode.SINGLE_LINE, "", LanguageMap.empty());
    }

    @Override
    public <R> R accept(@Nonnull FormControlDescriptorVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextControlDescriptor)) {
            return false;
        }
        TextControlDescriptor other = (TextControlDescriptor)obj;
        return this.placeholder.equals(other.placeholder) && this.stringType.equals((Object)other.stringType) && this.pattern.equals(other.pattern) && this.patternViolationErrorMessage.equals(other.patternViolationErrorMessage) && this.lineMode.equals((Object)other.lineMode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TextControlDescriptor").add("placeholder", (Object)this.placeholder).add("stringType", (Object)this.stringType).add("pattern", (Object)this.pattern).add("patternViolationErrorMessage", (Object)this.patternViolationErrorMessage).add("lineMode", (Object)this.lineMode).toString();
    }

    @Override
    @Nonnull
    @JsonIgnore
    public String getAssociatedType() {
        return TYPE;
    }

    @Nonnull
    public LineMode getLineMode() {
        return this.lineMode;
    }

    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    @Nonnull
    public LanguageMap getPatternViolationErrorMessage() {
        return this.patternViolationErrorMessage;
    }

    @Nonnull
    public LanguageMap getPlaceholder() {
        return this.placeholder;
    }

    @Nonnull
    public StringType getStringType() {
        return this.stringType;
    }

    @Nonnull
    public String getSpecificLangTag() {
        return this.specificLangTag;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.placeholder, this.stringType, this.pattern, this.patternViolationErrorMessage, this.lineMode});
    }
}

