/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ChangeRequestId;
import edu.stanford.protege.webprotege.common.ContentChangeRequest;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.ProjectRequest;
import edu.stanford.protege.webprotege.forms.DeprecateEntityByFormResult;
import edu.stanford.protege.webprotege.forms.data.FormData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;

@JsonTypeName(value="webprotege.forms.DeprecateEntityByForm")
public class DeprecateEntityByFormAction
implements ProjectRequest<DeprecateEntityByFormResult>,
ContentChangeRequest {
    public static final String CHANNEL = "webprotege.forms.DeprecateEntityByFormAction";
    private final OWLEntity entity;
    @Nullable
    private final FormData deprecationFormData;
    private final OWLEntity replacementEntity;
    private final ProjectId projectId;
    private final ChangeRequestId changeRequestId;

    public DeprecateEntityByFormAction(@Nonnull ChangeRequestId changeRequestId, OWLEntity entity, Optional<FormData> deprecationFormData, Optional<OWLEntity> replacementEntity, ProjectId projectId) {
        boolean entityTypesAreTheSame;
        this.changeRequestId = (ChangeRequestId)Preconditions.checkNotNull((Object)changeRequestId);
        this.entity = (OWLEntity)Preconditions.checkNotNull((Object)entity);
        this.deprecationFormData = ((Optional)Preconditions.checkNotNull(deprecationFormData)).orElse(null);
        this.replacementEntity = ((Optional)Preconditions.checkNotNull(replacementEntity)).orElse(null);
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        if (replacementEntity.isPresent() && !(entityTypesAreTheSame = replacementEntity.get().getEntityType().equals(entity.getEntityType()))) {
            throw new IllegalArgumentException("Entity types for the term being deprecated and the replacement term must be the same");
        }
    }

    public ChangeRequestId changeRequestId() {
        return this.changeRequestId;
    }

    public String getChannel() {
        return CHANNEL;
    }

    @Nonnull
    public ProjectId projectId() {
        return this.projectId;
    }

    @Nonnull
    public OWLEntity getEntity() {
        return this.entity;
    }

    public Optional<FormData> getDeprecationFormData() {
        return Optional.ofNullable(this.deprecationFormData);
    }

    public Optional<OWLEntity> getReplacementEntity() {
        return Optional.ofNullable(this.replacementEntity);
    }
}

