/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.data.FormData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public record FormDataByFormId(Map<FormId, FormData> map) {
    private final Map<FormId, FormData> map;

    public FormDataByFormId(Map<FormId, FormData> map) {
        this.map = new LinkedHashMap<FormId, FormData>((Map)Preconditions.checkNotNull(map));
    }

    @JsonCreator
    public static FormDataByFormId valueOf(Map<FormId, FormData> map) {
        return new FormDataByFormId(map);
    }

    @JsonValue
    public Map<FormId, FormData> map() {
        return new LinkedHashMap<FormId, FormData>(this.map);
    }

    @Nonnull
    public Collection<FormId> getFormIds() {
        return ImmutableSet.copyOf(this.map.keySet());
    }

    @Nonnull
    public Optional<FormData> getFormData(@Nonnull FormId formId) {
        return Optional.ofNullable(this.map.get(formId));
    }

    public boolean contains(FormId formId) {
        return this.map.containsKey(formId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormDataByFormId)) {
            return false;
        }
        FormDataByFormId that = (FormDataByFormId)o;
        return this.map.equals(that.map);
    }

    @Override
    public String toString() {
        return "FormDataByFormId{" + this.map + "}";
    }
}

