/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.UUIDUtil;
import edu.stanford.protege.webprotege.forms.AutoValue_FormGroupId;
import java.util.UUID;
import javax.annotation.Nonnull;

@AutoValue
public abstract class FormGroupId {
    @JsonCreator
    public static FormGroupId get(@Nonnull String id) {
        FormGroupId.checkFormat(id);
        return new AutoValue_FormGroupId(id);
    }

    public static FormGroupId generate() {
        return FormGroupId.get(UUID.randomUUID().toString());
    }

    public static void checkFormat(@Nonnull String id) {
        if (!UUIDUtil.isWellFormed((String)id)) {
            throw new RuntimeException("Malformed FormGroupId.  FormGroupIds should be UUIDs");
        }
    }

    @JsonValue
    @Nonnull
    public abstract String getId();
}

