/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ValueObject;
import edu.stanford.protege.webprotege.forms.AutoValue_FormId;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nonnull;

@AutoValue
public abstract class FormId
implements Serializable,
ValueObject {
    @JsonCreator
    public static FormId get(@Nonnull String id) {
        FormId.checkFormat(id);
        return new AutoValue_FormId(id);
    }

    @Nonnull
    public static FormId valueOf(@Nonnull String id) {
        return FormId.get(id);
    }

    public static FormId generate() {
        return FormId.get(UUID.randomUUID().toString());
    }

    public static void checkFormat(@Nonnull String id) {
        UUID.fromString(id);
    }

    public String value() {
        return this.getId();
    }

    @JsonValue
    public abstract String getId();
}

