/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.forms.data.AutoValue_EntityFormControlData;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlDataProxy;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLPrimitive;

@AutoValue
public abstract class EntityFormControlData
implements PrimitiveFormControlData {
    @JsonCreator
    public static EntityFormControlData get(@Nonnull OWLEntity entity) {
        return new AutoValue_EntityFormControlData(entity);
    }

    @JsonValue
    @Nonnull
    public abstract OWLEntity getEntity();

    @Override
    @Nonnull
    public Optional<OWLEntity> asEntity() {
        return Optional.of(this.getEntity());
    }

    @Override
    @Nonnull
    public Optional<IRI> asIri() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<OWLLiteral> asLiteral() {
        return Optional.empty();
    }

    @Override
    @JsonIgnore
    @Nonnull
    public OWLPrimitive getPrimitive() {
        return this.getEntity();
    }

    @Override
    public PrimitiveFormControlDataProxy toPrimitiveFormControlDataProxy() {
        return new PrimitiveFormControlDataProxy(this.getEntity().getIRI().toString(), this.getEntity().getEntityType().getName(), null, null, null);
    }
}

