/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.forms.FormDescriptor;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.data.AutoValue_FormData;
import edu.stanford.protege.webprotege.forms.data.FormControlData;
import edu.stanford.protege.webprotege.forms.data.FormControlDataVisitor;
import edu.stanford.protege.webprotege.forms.data.FormControlDataVisitorEx;
import edu.stanford.protege.webprotege.forms.data.FormEntitySubject;
import edu.stanford.protege.webprotege.forms.data.FormFieldData;
import edu.stanford.protege.webprotege.forms.data.FormSubject;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;

@JsonTypeName(value="FormData")
@AutoValue
public abstract class FormData
implements FormControlData {
    @JsonCreator
    public static FormData get(@JsonProperty(value="subject") @Nonnull Optional<FormEntitySubject> subject, @JsonProperty(value="form") @Nonnull FormDescriptor formDescriptor, @JsonProperty(value="fields") @Nonnull ImmutableList<FormFieldData> formFieldData) {
        return new AutoValue_FormData(subject.orElse(null), formDescriptor, formFieldData);
    }

    public static FormData empty(@Nonnull OWLEntity entity, @Nonnull FormId formId) {
        return FormData.get(Optional.of(FormSubject.get(entity)), FormDescriptor.empty(formId), (ImmutableList<FormFieldData>)ImmutableList.of());
    }

    @Override
    public <R> R accept(@Nonnull FormControlDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@Nonnull FormControlDataVisitor visitor) {
        visitor.visit(this);
    }

    @JsonIgnore
    @Nonnull
    public Optional<FormEntitySubject> getSubject() {
        return Optional.ofNullable(this.getSubjectInternal());
    }

    @JsonProperty(value="subject")
    @Nullable
    protected abstract FormEntitySubject getSubjectInternal();

    @JsonProperty(value="form")
    public abstract FormDescriptor getFormDescriptor();

    @JsonProperty(value="fields")
    public abstract ImmutableList<FormFieldData> getFormFieldData();

    @Nonnull
    public FormId getFormId() {
        return this.getFormDescriptor().getFormId();
    }
}

