/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.Page;
import edu.stanford.protege.webprotege.forms.FormDescriptorDto;
import edu.stanford.protege.webprotege.forms.FormId;
import edu.stanford.protege.webprotege.forms.data.AutoValue_FormDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlData;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDtoVisitorEx;
import edu.stanford.protege.webprotege.forms.data.FormData;
import edu.stanford.protege.webprotege.forms.data.FormFieldData;
import edu.stanford.protege.webprotege.forms.data.FormFieldDataDto;
import edu.stanford.protege.webprotege.forms.data.FormSubjectDto;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonTypeName(value="FormDataDto")
@AutoValue
public abstract class FormDataDto
implements FormControlDataDto {
    @JsonCreator
    @Nonnull
    public static FormDataDto get(@JsonProperty(value="subject") @Nonnull FormSubjectDto subject, @JsonProperty(value="form") @Nonnull FormDescriptorDto formDescriptor, @JsonProperty(value="fields") @Nonnull ImmutableList<FormFieldDataDto> formFieldData, @JsonProperty(value="depth") int depth) {
        return new AutoValue_FormDataDto(depth, subject, formDescriptor, formFieldData);
    }

    @Nonnull
    public static FormDataDto get(@Nonnull FormSubjectDto subject, @Nonnull FormDescriptorDto formDescriptor, int depth) {
        ImmutableList emptyFields = (ImmutableList)formDescriptor.getFields().stream().map(field -> FormFieldDataDto.get(field, (Page<FormControlDataDto>)Page.emptyPage())).collect(ImmutableList.toImmutableList());
        return new AutoValue_FormDataDto(depth, subject, formDescriptor, (ImmutableList<FormFieldDataDto>)emptyFields);
    }

    @Nonnull
    public static FormDataDto get(@Nonnull FormDescriptorDto formDescriptor, @Nonnull ImmutableList<FormFieldDataDto> formFieldData, int depth) {
        return new AutoValue_FormDataDto(depth, null, formDescriptor, formFieldData);
    }

    @JsonIgnore
    @Nonnull
    public Optional<FormSubjectDto> getSubject() {
        return Optional.ofNullable(this.getSubjectInternal());
    }

    @JsonProperty(value="subject")
    @Nullable
    protected abstract FormSubjectDto getSubjectInternal();

    @JsonProperty(value="form")
    public abstract FormDescriptorDto getFormDescriptor();

    @JsonProperty(value="fields")
    public abstract ImmutableList<FormFieldDataDto> getFormFieldData();

    @Override
    public <R> R accept(FormControlDataDtoVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public FormControlData toFormControlData() {
        return FormData.get(this.getSubject().map(FormSubjectDto::toFormSubject), this.getFormDescriptor().toFormDescriptor(), (ImmutableList<FormFieldData>)((ImmutableList)this.getFormFieldData().stream().map(FormFieldDataDto::getFormFieldData).collect(ImmutableList.toImmutableList())));
    }

    @Nonnull
    public FormData toFormData() {
        return FormData.get(this.getSubject().map(FormSubjectDto::toFormSubject), this.getFormDescriptor().toFormDescriptor(), (ImmutableList<FormFieldData>)((ImmutableList)this.getFormFieldData().stream().map(FormFieldDataDto::toFormFieldData).collect(ImmutableList.toImmutableList())));
    }

    @JsonIgnore
    @Nonnull
    public FormId getFormId() {
        return this.getFormDescriptor().getFormId();
    }
}

