/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.Page;
import edu.stanford.protege.webprotege.forms.data.AutoValue_GridCellData;
import edu.stanford.protege.webprotege.forms.data.EntityNameControlData;
import edu.stanford.protege.webprotege.forms.data.FormControlData;
import edu.stanford.protege.webprotege.forms.data.TextControlData;
import edu.stanford.protege.webprotege.forms.field.FormRegionId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

@AutoValue
public abstract class GridCellData {
    @JsonCreator
    public static GridCellData get(@JsonProperty(value="columnId") @Nonnull FormRegionId columnId, @JsonProperty(value="values") @Nullable Page<FormControlData> values) {
        return new AutoValue_GridCellData(columnId, values);
    }

    public int compareTo(GridCellData otherCellData) {
        Page<FormControlData> valuesPage = this.getValues();
        Page<FormControlData> otherValuesPage = otherCellData.getValues();
        ImmutableList values = valuesPage.getPageElements();
        ImmutableList otherValues = otherValuesPage.getPageElements();
        for (int i = 0; i < values.size() && i < otherValues.size(); ++i) {
            int diff;
            Optional<OWLLiteral> otherValue;
            Optional<OWLLiteral> value;
            FormControlData formControlData = (FormControlData)values.get(i);
            FormControlData otherControlData = (FormControlData)otherValues.get(i);
            if (formControlData instanceof TextControlData && otherControlData instanceof TextControlData) {
                value = ((TextControlData)formControlData).getValue();
                otherValue = ((TextControlData)otherControlData).getValue();
                if (value.isPresent() && otherValue.isPresent() && (diff = value.get().compareTo((Object)((OWLObject)otherValue.get()))) != 0) {
                    return diff;
                }
            }
            if (!(formControlData instanceof EntityNameControlData) || !(otherControlData instanceof EntityNameControlData)) continue;
            value = ((EntityNameControlData)formControlData).getEntity();
            otherValue = ((EntityNameControlData)otherControlData).getEntity();
            if (!value.isPresent() || !otherValue.isPresent() || (diff = ((OWLEntity)value.get()).compareTo((Object)((OWLObject)otherValue.get()))) == 0) continue;
            return diff;
        }
        return 0;
    }

    @JsonProperty(value="columnId")
    @Nonnull
    public abstract FormRegionId getColumnId();

    @JsonProperty(value="values")
    @Nonnull
    public abstract Page<FormControlData> getValues();
}

