/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.common.Page;
import edu.stanford.protege.webprotege.forms.FilterState;
import edu.stanford.protege.webprotege.forms.HasFilterState;
import edu.stanford.protege.webprotege.forms.data.AutoValue_GridControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDtoVisitorEx;
import edu.stanford.protege.webprotege.forms.data.GridControlData;
import edu.stanford.protege.webprotege.forms.data.GridRowData;
import edu.stanford.protege.webprotege.forms.data.GridRowDataDto;
import edu.stanford.protege.webprotege.forms.field.FormRegionOrdering;
import edu.stanford.protege.webprotege.forms.field.GridControlDescriptor;
import javax.annotation.Nonnull;

@JsonTypeName(value="GridControlDataDto")
@AutoValue
public abstract class GridControlDataDto
implements FormControlDataDto,
HasFilterState {
    @JsonCreator
    @Nonnull
    public static GridControlDataDto get(@JsonProperty(value="control") @Nonnull GridControlDescriptor descriptor, @JsonProperty(value="rows") @Nonnull Page<GridRowDataDto> rows, @JsonProperty(value="ordering") @Nonnull ImmutableSet<FormRegionOrdering> ordering, @JsonProperty(value="depth") int depth, @JsonProperty(value="filterState") @Nonnull FilterState filterState) {
        return new AutoValue_GridControlDataDto(depth, descriptor, rows, ordering, filterState);
    }

    @JsonProperty(value="control")
    @Nonnull
    public abstract GridControlDescriptor getDescriptor();

    @JsonProperty(value="rows")
    @Nonnull
    public abstract Page<GridRowDataDto> getRows();

    @JsonProperty(value="ordering")
    @Nonnull
    public abstract ImmutableSet<FormRegionOrdering> getOrdering();

    @Override
    public <R> R accept(FormControlDataDtoVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public GridControlData toFormControlData() {
        return GridControlData.get(this.getDescriptor(), (Page<GridRowData>)this.getRows().transform(GridRowDataDto::toGridRowData), this.getOrdering());
    }

    @Override
    @JsonProperty(value="filterState")
    @Nonnull
    public abstract FilterState getFilterState();

    @JsonIgnore
    public boolean isFilteredEmpty() {
        return this.getFilterState().equals((Object)FilterState.FILTERED) && this.getRows().getTotalElements() == 0L;
    }
}

