/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.forms.data.AutoValue_GridRowData;
import edu.stanford.protege.webprotege.forms.data.FormEntitySubject;
import edu.stanford.protege.webprotege.forms.data.GridCellData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class GridRowData
implements Comparable<GridRowData> {
    @JsonCreator
    public static GridRowData get(@JsonProperty(value="subject") @Nullable FormEntitySubject subject, @JsonProperty(value="cells") @Nonnull ImmutableList<GridCellData> cellData) {
        return new AutoValue_GridRowData(subject, cellData);
    }

    @JsonProperty(value="subject")
    @Nullable
    protected abstract FormEntitySubject getSubjectInternal();

    @JsonIgnore
    @Nonnull
    public Optional<FormEntitySubject> getSubject() {
        return Optional.ofNullable(this.getSubjectInternal());
    }

    @JsonProperty(value="cells")
    @Nonnull
    public abstract ImmutableList<GridCellData> getCells();

    @Override
    public int compareTo(GridRowData o) {
        ImmutableList<GridCellData> cells = this.getCells();
        ImmutableList<GridCellData> otherCells = o.getCells();
        for (int i = 0; i < cells.size() && i < otherCells.size(); ++i) {
            GridCellData otherCellData;
            GridCellData cellData = (GridCellData)cells.get(i);
            int diff = cellData.compareTo(otherCellData = (GridCellData)otherCells.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

