/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.forms.data.AutoValue_ImageControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlData;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDtoVisitorEx;
import edu.stanford.protege.webprotege.forms.data.ImageControlData;
import edu.stanford.protege.webprotege.forms.field.ImageControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;

@JsonTypeName(value="ImageControlDataDto")
@AutoValue
public abstract class ImageControlDataDto
implements FormControlDataDto {
    @JsonCreator
    @Nonnull
    public static ImageControlDataDto get(@JsonProperty(value="control") @Nonnull ImageControlDescriptor descriptor, @JsonProperty(value="iri") @Nonnull IRI iri, @JsonProperty(value="depth") int depth) {
        return new AutoValue_ImageControlDataDto(depth, descriptor, iri);
    }

    @JsonProperty(value="control")
    @Nonnull
    public abstract ImageControlDescriptor getDescriptor();

    @JsonProperty(value="iri")
    @Nullable
    protected abstract IRI getIriInternal();

    @JsonIgnore
    @Nonnull
    public Optional<IRI> getIri() {
        return Optional.ofNullable(this.getIriInternal());
    }

    @Override
    public <R> R accept(FormControlDataDtoVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public FormControlData toFormControlData() {
        return ImageControlData.get(this.getDescriptor(), this.getIriInternal());
    }
}

