/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.forms.data.AutoValue_NumberControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.FormControlDataDtoVisitorEx;
import edu.stanford.protege.webprotege.forms.data.NumberControlData;
import edu.stanford.protege.webprotege.forms.field.NumberControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLLiteral;

@JsonTypeName(value="NumberControlDataDto")
@AutoValue
public abstract class NumberControlDataDto
implements FormControlDataDto,
Comparable<NumberControlDataDto> {
    private Double numericValue;

    @JsonCreator
    @Nonnull
    public static NumberControlDataDto get(@JsonProperty(value="control") @Nonnull NumberControlDescriptor descriptor, @JsonProperty(value="value") @Nonnull OWLLiteral value, @JsonProperty(value="depth") int depth) {
        return new AutoValue_NumberControlDataDto(depth, descriptor, value);
    }

    @JsonProperty(value="control")
    @Nonnull
    public abstract NumberControlDescriptor getDescriptor();

    @JsonProperty(value="value")
    @Nullable
    protected abstract OWLLiteral getValueInternal();

    @Nonnull
    @JsonIgnore
    public Optional<OWLLiteral> getValue() {
        return Optional.ofNullable(this.getValueInternal());
    }

    @Override
    public <R> R accept(FormControlDataDtoVisitorEx<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public NumberControlData toFormControlData() {
        return NumberControlData.get(this.getDescriptor(), this.getValueInternal());
    }

    private Double getNumericValue() {
        if (this.numericValue == null) {
            OWLLiteral literal = this.getValueInternal();
            if (literal == null) {
                this.numericValue = Double.MIN_VALUE;
            } else {
                try {
                    this.numericValue = Double.parseDouble(literal.getLiteral().trim());
                }
                catch (NumberFormatException e) {
                    this.numericValue = Double.MIN_VALUE;
                }
            }
        }
        return this.numericValue;
    }

    @Override
    public int compareTo(@Nonnull NumberControlDataDto o) {
        return this.getNumericValue().compareTo(o.getNumericValue());
    }
}

