/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.stanford.protege.webprotege.entity.IRIData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.entity.OWLLiteralData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.forms.data.AutoValue_EntityFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.AutoValue_IriFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.AutoValue_LiteralFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.EntityFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.IriFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.LiteralFormControlDataDto;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLLiteral;

@JsonSubTypes(value={@JsonSubTypes.Type(value=EntityFormControlDataDto.class), @JsonSubTypes.Type(value=LiteralFormControlDataDto.class), @JsonSubTypes.Type(value=IriFormControlDataDto.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
public abstract class PrimitiveFormControlDataDto
implements Comparable<PrimitiveFormControlDataDto> {
    public static final int BEFORE = -1;
    public static final int AFTER = 1;

    public static EntityFormControlDataDto get(OWLEntityData entity) {
        return new AutoValue_EntityFormControlDataDto(entity);
    }

    public static PrimitiveFormControlDataDto get(IRIData iri) {
        return new AutoValue_IriFormControlDataDto(iri);
    }

    public static LiteralFormControlDataDto get(OWLLiteralData literal) {
        return new AutoValue_LiteralFormControlDataDto(literal);
    }

    @Nonnull
    public abstract PrimitiveFormControlData toPrimitiveFormControlData();

    @Nonnull
    public abstract Optional<OWLLiteral> asLiteral();

    @Override
    public int compareTo(@Nonnull PrimitiveFormControlDataDto other) {
        if (this instanceof LiteralFormControlDataDto) {
            if (other instanceof LiteralFormControlDataDto) {
                return ((LiteralFormControlDataDto)this).getLiteral().compareTo((OWLPrimitiveData)((LiteralFormControlDataDto)other).getLiteral());
            }
            return -1;
        }
        if (this instanceof EntityFormControlDataDto) {
            if (other instanceof EntityFormControlDataDto) {
                return ((EntityFormControlDataDto)this).getEntity().compareTo((OWLPrimitiveData)((EntityFormControlDataDto)other).getEntity());
            }
            if (other instanceof LiteralFormControlDataDto) {
                return 1;
            }
            return -1;
        }
        if (other instanceof IriFormControlDataDto) {
            return ((IriFormControlDataDto)this).getIri().compareTo((OWLPrimitiveData)((IriFormControlDataDto)other).getIri());
        }
        return 1;
    }

    @JsonIgnore
    public boolean isDeprecated() {
        return false;
    }

    @JsonIgnore
    @Nonnull
    public abstract OWLPrimitiveData getPrimitiveData();
}

