/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.stanford.protege.webprotege.forms.data.PrimitiveFormControlData;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public record PrimitiveFormControlDataProxy(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @Nullable String iri, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="@type") @Nullable String type, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @Nullable String value, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="type") @Nullable String datatype, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @Nullable String lang) {
    public PrimitiveFormControlData toPrimitiveFormControlData() {
        if (this.type != null) {
            if (this.iri == null) {
                throw new RuntimeException("Missing iri");
            }
            if (EntityType.CLASS.getName().equals(this.type) || EntityType.CLASS.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLClassImpl(IRI.create((String)this.iri)));
            }
            if (EntityType.OBJECT_PROPERTY.getName().equals(this.type) || EntityType.OBJECT_PROPERTY.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLObjectPropertyImpl(IRI.create((String)this.iri)));
            }
            if (EntityType.DATA_PROPERTY.getName().equals(this.type) || EntityType.DATA_PROPERTY.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLDataPropertyImpl(IRI.create((String)this.iri)));
            }
            if (EntityType.ANNOTATION_PROPERTY.getName().equals(this.type) || EntityType.ANNOTATION_PROPERTY.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLAnnotationPropertyImpl(IRI.create((String)this.iri)));
            }
            if (EntityType.DATATYPE.getName().equals(this.type) || EntityType.DATATYPE.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLDatatypeImpl(IRI.create((String)this.iri)));
            }
            if (EntityType.NAMED_INDIVIDUAL.getName().equals(this.type) || EntityType.NAMED_INDIVIDUAL.getPrefixedName().equals(this.type)) {
                return PrimitiveFormControlData.get((OWLEntity)new OWLNamedIndividualImpl(IRI.create((String)this.iri)));
            }
            throw new RuntimeException("Unrecongized entity type: " + this.type);
        }
        if (this.iri != null) {
            return PrimitiveFormControlData.get(IRI.create((String)this.iri));
        }
        if (this.value != null) {
            OWLDatatypeImpl dt = null;
            if (this.datatype != null) {
                dt = new OWLDatatypeImpl(IRI.create((String)this.datatype));
            }
            return PrimitiveFormControlData.get((OWLLiteral)new OWLLiteralImpl(this.value, this.lang, (OWLDatatype)dt));
        }
        throw new RuntimeException("Expected @type, iri or value");
    }
}

