/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.ExpansionState;
import edu.stanford.protege.webprotege.forms.HasFormRegionId;
import edu.stanford.protege.webprotege.forms.field.AutoValue_FormFieldDescriptor;
import edu.stanford.protege.webprotege.forms.field.BoundControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FieldRun;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormFieldDeprecationStrategy;
import edu.stanford.protege.webprotege.forms.field.FormRegionId;
import edu.stanford.protege.webprotege.forms.field.HasRepeatability;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import edu.stanford.protege.webprotege.forms.field.SubFormControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "owlBinding", "label", "fieldRun", "control", "repeatability", "optionality", "readOnly", "help"})
@AutoValue
public abstract class FormFieldDescriptor
implements HasFormRegionId,
HasRepeatability,
BoundControlDescriptor {
    @Nonnull
    public static FormFieldDescriptor get(@Nonnull FormRegionId id, @Nullable OwlBinding owlBinding, @Nullable LanguageMap formLabel, @Nullable FieldRun fieldRun, @Nullable FormFieldDeprecationStrategy deprecationStrategy, @Nonnull FormControlDescriptor fieldDescriptor, Repeatability repeatability, Optionality optionality, boolean readOnly, @Nullable ExpansionState expansionState, @Nullable LanguageMap help) {
        return new AutoValue_FormFieldDescriptor(id, owlBinding, formLabel == null ? LanguageMap.empty() : formLabel, fieldRun == null ? FieldRun.START : fieldRun, fieldDescriptor, optionality == null ? Optionality.REQUIRED : optionality, repeatability == null ? Repeatability.NON_REPEATABLE : repeatability, deprecationStrategy == null ? FormFieldDeprecationStrategy.DELETE_VALUES : deprecationStrategy, readOnly, expansionState == null ? ExpansionState.EXPANDED : expansionState, help == null ? LanguageMap.empty() : help);
    }

    @JsonCreator
    @Nonnull
    public static FormFieldDescriptor getFromJson(@JsonProperty(value="id") @Nonnull FormRegionId id, @JsonProperty(value="owlBinding") @Nullable OwlBinding owlBinding, @JsonProperty(value="label") @Nullable LanguageMap formLabel, @JsonProperty(value="fieldRun") @Nullable FieldRun fieldRun, @JsonProperty(value="deprecationStrategy") @Nullable FormFieldDeprecationStrategy deprecationStrategy, @JsonProperty(value="control") @Nonnull FormControlDescriptor fieldDescriptor, @JsonProperty(value="repeatability") @Nullable Repeatability repeatability, @JsonProperty(value="optionality") @Nullable Optionality optionality, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="initialExpansionState") @Nullable ExpansionState expansionState, @JsonProperty(value="help") @Nullable LanguageMap help) {
        return FormFieldDescriptor.get(id, owlBinding, formLabel, fieldRun, deprecationStrategy, fieldDescriptor, repeatability, optionality, readOnly, expansionState, help);
    }

    @Override
    @Nonnull
    public abstract FormRegionId getId();

    @JsonProperty(value="owlBinding")
    @Nullable
    protected abstract OwlBinding getOwlBindingInternal();

    @Override
    @Nonnull
    @JsonIgnore
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    @JsonProperty(value="label")
    public abstract LanguageMap getLabel();

    @Nonnull
    @JsonProperty(value="fieldRun")
    public abstract FieldRun getFieldRun();

    @Override
    @Nonnull
    @JsonProperty(value="control")
    public abstract FormControlDescriptor getFormControlDescriptor();

    @Nonnull
    public abstract Optionality getOptionality();

    @Override
    @Nonnull
    public abstract Repeatability getRepeatability();

    @JsonProperty(value="deprecationStrategy")
    @Nonnull
    public abstract FormFieldDeprecationStrategy getDeprecationStrategy();

    @JsonProperty(value="readOnly")
    public abstract boolean isReadOnly();

    @JsonProperty(value="initialExpansionState")
    @Nonnull
    public abstract ExpansionState getInitialExpansionState();

    @Nonnull
    @JsonProperty(value="help")
    public abstract LanguageMap getHelp();

    @JsonIgnore
    public boolean isComposite() {
        return this.getFormControlDescriptor() instanceof SubFormControlDescriptor;
    }
}

