/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.ExpansionState;
import edu.stanford.protege.webprotege.forms.HasFormRegionId;
import edu.stanford.protege.webprotege.forms.field.AutoValue_FormFieldDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FieldRun;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormFieldDeprecationStrategy;
import edu.stanford.protege.webprotege.forms.field.FormFieldDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormRegionId;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import edu.stanford.protege.webprotege.forms.field.SubFormControlDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class FormFieldDescriptorDto
implements HasFormRegionId {
    @JsonCreator
    @Nonnull
    public static FormFieldDescriptorDto get(@JsonProperty(value="id") FormRegionId formRegionId, @JsonProperty(value="owlBinding") OwlBinding owlBinding, @JsonProperty(value="label") LanguageMap newlabel, @JsonProperty(value="fieldRun") FieldRun fieldRun, @JsonProperty(value="control") FormControlDescriptorDto descriptorDto, @JsonProperty(value="optionality") Optionality optionality, @JsonProperty(value="repeatability") Repeatability repeatability, @JsonProperty(value="deprecationStrategy") FormFieldDeprecationStrategy deprecationStrategy, @JsonProperty(value="readOnly") boolean newReadOnly, @JsonProperty(value="initialExpansionState") ExpansionState initialExpansionState, @JsonProperty(value="help") LanguageMap help) {
        return new AutoValue_FormFieldDescriptorDto(formRegionId, owlBinding, newlabel, fieldRun, descriptorDto, optionality, repeatability, deprecationStrategy, newReadOnly, initialExpansionState, help);
    }

    @Override
    @Nonnull
    @JsonProperty(value="id")
    public abstract FormRegionId getId();

    @JsonProperty(value="owlBinding")
    @Nullable
    protected abstract OwlBinding getOwlBindingInternal();

    @JsonIgnore
    @Nonnull
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    @JsonProperty(value="label")
    public abstract LanguageMap getLabel();

    @Nonnull
    @JsonProperty(value="fieldRun")
    public abstract FieldRun getFieldRun();

    @JsonProperty(value="control")
    @Nonnull
    public abstract FormControlDescriptorDto getFormControlDescriptor();

    @Nonnull
    @JsonProperty(value="optionality")
    public abstract Optionality getOptionality();

    @Nonnull
    @JsonProperty(value="repeatability")
    public abstract Repeatability getRepeatability();

    @Nonnull
    @JsonProperty(value="deprecationStrategy")
    public abstract FormFieldDeprecationStrategy getDeprecationStrategy();

    @JsonProperty(value="readOnly")
    public abstract boolean isReadOnly();

    @Nonnull
    @JsonProperty(value="initialExpansionState")
    public abstract ExpansionState getInitialExpansionState();

    @Nonnull
    @JsonProperty(value="help")
    public abstract LanguageMap getHelp();

    @JsonIgnore
    public boolean isComposite() {
        return this.getFormControlDescriptor() instanceof SubFormControlDescriptor;
    }

    public FormFieldDescriptor toFormFieldDescriptor() {
        return FormFieldDescriptor.get(this.getId(), this.getOwlBindingInternal(), this.getLabel(), this.getFieldRun(), this.getDeprecationStrategy(), this.getFormControlDescriptor().toFormControlDescriptor(), this.getRepeatability(), this.getOptionality(), this.isReadOnly(), this.getInitialExpansionState(), this.getHelp());
    }
}

