/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.stanford.protege.webprotege.common.UUIDUtil;
import edu.stanford.protege.webprotege.common.ValueObject;
import java.util.UUID;
import javax.annotation.Nonnull;

public record FormRegionId(String value) implements ValueObject
{
    public FormRegionId(String value) {
        this.value = FormRegionId.checkFormat(value);
    }

    public static FormRegionId generate() {
        return FormRegionId.get(UUID.randomUUID().toString());
    }

    @JsonCreator
    @Nonnull
    public static FormRegionId get(@Nonnull String id) {
        return new FormRegionId(id);
    }

    public static FormRegionId valueOf(String id) {
        return FormRegionId.get(id);
    }

    private static String checkFormat(@Nonnull String id) {
        if (!UUIDUtil.isWellFormed((String)id)) {
            throw new IllegalArgumentException("Malformed FormRegionId: " + id);
        }
        return id;
    }
}

