/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.field.AutoValue_GridColumnDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.FormRegionId;
import edu.stanford.protege.webprotege.forms.field.GridColumnDescriptor;
import edu.stanford.protege.webprotege.forms.field.GridControlDescriptorDto;
import edu.stanford.protege.webprotege.forms.field.Optionality;
import edu.stanford.protege.webprotege.forms.field.OwlBinding;
import edu.stanford.protege.webprotege.forms.field.Repeatability;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class GridColumnDescriptorDto {
    @JsonCreator
    @Nonnull
    public static GridColumnDescriptorDto get(@JsonProperty(value="id") @Nonnull FormRegionId columnId, @JsonProperty(value="optionality") @Nonnull Optionality optionality, @JsonProperty(value="repeatability") @Nonnull Repeatability repeatability, @JsonProperty(value="owlBinding") @Nullable OwlBinding binding, @JsonProperty(value="label") @Nonnull LanguageMap label, @JsonProperty(value="control") @Nonnull FormControlDescriptorDto formControlDescriptorDto) {
        return new AutoValue_GridColumnDescriptorDto(columnId, optionality, repeatability, binding, label, formControlDescriptorDto);
    }

    @Nonnull
    @JsonProperty(value="id")
    public abstract FormRegionId getId();

    @Nonnull
    @JsonProperty(value="optionality")
    public abstract Optionality getOptionality();

    @Nonnull
    @JsonProperty(value="repeatability")
    public abstract Repeatability getRepeatability();

    @Nullable
    @JsonProperty(value="owlBinding")
    protected abstract OwlBinding getOwlBindingInternal();

    @Nonnull
    @JsonIgnore
    public Optional<OwlBinding> getOwlBinding() {
        return Optional.ofNullable(this.getOwlBindingInternal());
    }

    @Nonnull
    @JsonProperty(value="label")
    public abstract LanguageMap getLabel();

    @Nonnull
    @JsonProperty(value="control")
    public abstract FormControlDescriptorDto getFormControlDescriptor();

    public GridColumnDescriptor toGridColumnDescriptor() {
        return GridColumnDescriptor.get(this.getId(), this.getOptionality(), this.getRepeatability(), this.getOwlBindingInternal(), this.getLabel(), this.getFormControlDescriptor().toFormControlDescriptor());
    }

    @JsonIgnore
    public int getNestedColumnCount() {
        FormControlDescriptorDto formControlDescriptor = this.getFormControlDescriptor();
        if (formControlDescriptor instanceof GridControlDescriptorDto) {
            return ((GridControlDescriptorDto)this.getFormControlDescriptor()).getNestedColumnCount();
        }
        return 1;
    }

    @JsonIgnore
    public Stream<GridColumnDescriptorDto> getLeafColumnDescriptors() {
        FormControlDescriptorDto formControlDescriptor = this.getFormControlDescriptor();
        if (formControlDescriptor instanceof GridControlDescriptorDto) {
            return ((GridControlDescriptorDto)formControlDescriptor).getLeafColumns();
        }
        return Stream.of(this);
    }

    @JsonIgnore
    public boolean isLeafColumnDescriptor() {
        return !(this.getFormControlDescriptor() instanceof GridControlDescriptorDto);
    }
}

