/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Range;

public class NumberControlRange {
    private static final NumberControlRange ANY_NUMBER = new NumberControlRange(Double.MIN_VALUE, BoundType.INCLUSIVE, Double.MAX_VALUE, BoundType.INCLUSIVE);
    private Double lowerBound = Double.MIN_VALUE;
    private BoundType lowerBoundType = BoundType.INCLUSIVE;
    private Double upperBound = Double.MAX_VALUE;
    private BoundType upperBoundType = BoundType.INCLUSIVE;

    @JsonCreator
    private NumberControlRange(@JsonProperty(value="lowerBound") double lowerBound, @JsonProperty(value="lowerBoundType") BoundType lowerBoundType, @JsonProperty(value="upperBound") double upperBound, @JsonProperty(value="upperBoundType") BoundType upperBoundType) {
        this.lowerBound = lowerBound;
        this.lowerBoundType = lowerBoundType;
        this.upperBound = upperBound;
        this.upperBoundType = upperBoundType;
    }

    private NumberControlRange() {
    }

    public static NumberControlRange range(double lowerBound, BoundType lowerBoundType, double upperBound, BoundType upperBoundType) {
        return new NumberControlRange(lowerBound, lowerBoundType, upperBound, upperBoundType);
    }

    public static NumberControlRange all() {
        return ANY_NUMBER;
    }

    @JsonIgnore
    public boolean isAnyNumber() {
        return this.equals(ANY_NUMBER);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberControlRange)) {
            return false;
        }
        NumberControlRange other = (NumberControlRange)obj;
        return this.lowerBound.equals(other.lowerBound) && this.lowerBoundType.equals((Object)other.lowerBoundType) && this.upperBound.equals(other.upperBound) && this.upperBoundType.equals((Object)other.upperBoundType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.lowerBound, this.lowerBoundType, this.upperBound, this.upperBoundType});
    }

    public Range<Double> toRange() {
        return Range.range((Comparable)Double.valueOf(this.getLowerBound()), (com.google.common.collect.BoundType)(this.getLowerBoundType() == BoundType.INCLUSIVE ? com.google.common.collect.BoundType.CLOSED : com.google.common.collect.BoundType.OPEN), (Comparable)Double.valueOf(this.getUpperBound()), (com.google.common.collect.BoundType)(this.getUpperBoundType() == BoundType.INCLUSIVE ? com.google.common.collect.BoundType.CLOSED : com.google.common.collect.BoundType.OPEN));
    }

    @JsonProperty(value="lowerBound")
    public double getLowerBound() {
        return this.lowerBound;
    }

    @JsonProperty(value="lowerBoundType")
    public BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    @JsonProperty(value="upperBound")
    public double getUpperBound() {
        return this.upperBound;
    }

    @JsonProperty(value="upperBoundType")
    public BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NumberControlRange").add("lowerBound", (Object)this.lowerBound).add("lowerBoundType", (Object)this.lowerBoundType).add("upperBound", (Object)this.upperBound).add("upperBoundType", (Object)this.upperBoundType).toString();
    }

    public static enum BoundType {
        INCLUSIVE(">=", "<="),
        EXCLUSIVE(">", "<");

        private final String lowerSymbol;
        private final String upperSymbol;

        private BoundType(String lowerSymbol, String upperSymbol) {
            this.lowerSymbol = lowerSymbol;
            this.upperSymbol = upperSymbol;
        }

        public String getLowerSymbol() {
            return this.lowerSymbol;
        }

        public String getUpperSymbol() {
            return this.upperSymbol;
        }
    }
}

