/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.forms.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptor;
import edu.stanford.protege.webprotege.forms.field.FormControlDescriptorVisitor;
import edu.stanford.protege.webprotege.forms.field.LineMode;
import edu.stanford.protege.webprotege.forms.field.StringType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonTypeName(value="TEXT")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TextControlDescriptor
implements FormControlDescriptor {
    protected static final String TYPE = "TEXT";
    private LanguageMap placeholder = LanguageMap.empty();
    private StringType stringType = StringType.SIMPLE_STRING;
    private LineMode lineMode = LineMode.SINGLE_LINE;
    private String pattern = "";
    private LanguageMap patternViolationErrorMessage = LanguageMap.empty();
    private String specificLangTag = "";

    private TextControlDescriptor() {
    }

    @JsonCreator
    public TextControlDescriptor(@JsonProperty(value="placeholder") @Nullable LanguageMap placeholder, @JsonProperty(value="stringType") @Nonnull StringType stringType, @JsonProperty(value="specificLangTag") @Nullable String specificLangTag, @JsonProperty(value="lineMode") @Nonnull LineMode lineMode, @JsonProperty(value="pattern") @Nullable String pattern, @JsonProperty(value="patternViolationErrorMessage") @Nullable LanguageMap patternViolationErrorMessage) {
        this.placeholder = placeholder != null ? placeholder : LanguageMap.empty();
        this.stringType = (StringType)((Object)Preconditions.checkNotNull((Object)((Object)stringType)));
        this.specificLangTag = specificLangTag != null ? specificLangTag : "";
        this.lineMode = (LineMode)((Object)Preconditions.checkNotNull((Object)((Object)lineMode)));
        this.pattern = pattern != null ? pattern : "";
        this.patternViolationErrorMessage = patternViolationErrorMessage != null ? patternViolationErrorMessage : LanguageMap.empty();
    }

    @Nonnull
    public static String getType() {
        return TYPE;
    }

    public static TextControlDescriptor getDefault() {
        return new TextControlDescriptor(LanguageMap.empty(), StringType.SIMPLE_STRING, "", LineMode.SINGLE_LINE, "", LanguageMap.empty());
    }

    @Override
    public <R> R accept(@Nonnull FormControlDescriptorVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextControlDescriptor)) {
            return false;
        }
        TextControlDescriptor other = (TextControlDescriptor)obj;
        return this.placeholder.equals(other.placeholder) && this.stringType.equals((Object)other.stringType) && this.pattern.equals(other.pattern) && this.patternViolationErrorMessage.equals(other.patternViolationErrorMessage) && this.lineMode.equals((Object)other.lineMode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TextControlDescriptor").add("placeholder", (Object)this.placeholder).add("stringType", (Object)this.stringType).add("pattern", (Object)this.pattern).add("patternViolationErrorMessage", (Object)this.patternViolationErrorMessage).add("lineMode", (Object)this.lineMode).toString();
    }

    @Override
    @Nonnull
    @JsonIgnore
    public String getAssociatedType() {
        return TYPE;
    }

    @Nonnull
    @JsonProperty(value="lineMode")
    public LineMode getLineMode() {
        return this.lineMode;
    }

    @Nonnull
    @JsonProperty(value="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @Nonnull
    @JsonProperty(value="patternViolationErrorMessage")
    public LanguageMap getPatternViolationErrorMessage() {
        return this.patternViolationErrorMessage;
    }

    @Nonnull
    @JsonProperty(value="placeholder")
    public LanguageMap getPlaceholder() {
        return this.placeholder;
    }

    @Nonnull
    @JsonProperty(value="stringType")
    public StringType getStringType() {
        return this.stringType;
    }

    @Nonnull
    @JsonProperty(value="specificLangTag")
    public String getSpecificLangTag() {
        return this.specificLangTag;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.placeholder, this.stringType, this.pattern, this.patternViolationErrorMessage, this.lineMode});
    }
}

