/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import edu.stanford.protege.webprotege.ipc.CommandHandler;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarCommandHandlerWrapper;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarCommandHandlerWrapperFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PulsarCommandHandlersConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PulsarCommandHandlersConfiguration.class);
    @Autowired(required=false)
    private List<CommandHandler<?, ?>> commandHandlers = new ArrayList();
    @Autowired
    private PulsarCommandHandlerWrapperFactory wrapperFactory;

    @PostConstruct
    private void postConstruct() {
        logger.info("Command handlers configuration:");
        this.commandHandlers.forEach(handler -> {
            logger.info("Auto-detected command handler {} for channel {}", (Object)handler.getClass().getName(), (Object)handler.getChannelName());
            PulsarCommandHandlerWrapper wrapper = this.wrapperFactory.create(handler);
            wrapper.subscribe();
        });
    }
}

