/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.common.ProjectEvent;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.ipc.EventDispatcher;
import edu.stanford.protege.webprotege.ipc.EventRecord;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarProducersManager;
import java.util.Optional;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class PulsarEventDispatcher
implements EventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(PulsarEventDispatcher.class);
    private final String applicationName;
    private final PulsarProducersManager producersManager;
    private final ObjectMapper objectMapper;
    private final String tenant;

    public PulsarEventDispatcher(@Value(value="${spring.application.name}") String applicationName, PulsarProducersManager producersManager, ObjectMapper objectMapper, @Value(value="${webprotege.pulsar.tenant}") String tenant) {
        this.applicationName = applicationName;
        this.producersManager = producersManager;
        this.objectMapper = objectMapper;
        this.tenant = tenant;
    }

    @Override
    public void dispatchEvent(Event event) {
        this.createProducerAndDispatchEvent(event);
    }

    private void createProducerAndDispatchEvent(Event event) {
        String eventTopicUrl = this.tenant + "/events/" + event.getChannel();
        Producer<byte[]> producer = this.producersManager.getProducer(eventTopicUrl);
        this.serializeAndDispatchEvent(event, producer);
        this.serializeAndDispatchEventRecord(event);
    }

    private void serializeAndDispatchEvent(Event event, Producer<byte[]> producer) {
        try {
            byte[] value = this.objectMapper.writeValueAsBytes((Object)event);
            TypedMessageBuilder messageBuilder = producer.newMessage().value((Object)value);
            this.getJsonTypeName(event).ifPresent(typeName -> messageBuilder.property("webprotege_eventType", typeName));
            if (event instanceof ProjectEvent) {
                String projectId = ((ProjectEvent)event).projectId().value();
                messageBuilder.property("webprotege_projectId", projectId);
            }
            MessageId messageId = messageBuilder.send();
            logger.info("Sent event message: {}", (Object)messageId);
        }
        catch (JsonProcessingException e) {
            logger.info("Could not serialize event: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (PulsarClientException e) {
            logger.error("Could not send event message", (Throwable)e);
        }
    }

    private void serializeAndDispatchEventRecord(Event event) {
        try {
            String allEventsTopicUrl = this.tenant + "/events/webprotege.events.all";
            Producer<byte[]> allEventsProducer = this.producersManager.getProducer(allEventsTopicUrl);
            byte[] value = this.objectMapper.writeValueAsBytes((Object)event);
            ProjectId projectId = event instanceof ProjectEvent ? ((ProjectEvent)event).projectId() : null;
            long timestamp = System.currentTimeMillis();
            EventRecord record = new EventRecord(event.eventId(), timestamp, event.getChannel(), value, projectId);
            byte[] recordValue = this.objectMapper.writeValueAsBytes((Object)record);
            TypedMessageBuilder messageBuilder = allEventsProducer.newMessage().value((Object)recordValue).property("webprotege_eventType", event.getChannel());
            if (record.projectId() != null) {
                messageBuilder.property("webprotege_projectId", record.projectId().value());
            }
            MessageId messageId = messageBuilder.send();
            logger.info("Sent event record message: {}", (Object)messageId);
        }
        catch (JsonProcessingException e) {
            logger.info("Could not serialize event: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (PulsarClientException e) {
            logger.error("Could not send event message", (Throwable)e);
        }
    }

    private String getProducerName(Event event) {
        return this.applicationName + "--" + event.getChannel() + "--event-producer";
    }

    private Optional<String> getJsonTypeName(Event event) {
        JsonTypeName annotation = event.getClass().getAnnotation(JsonTypeName.class);
        return Optional.ofNullable(annotation).map(JsonTypeName::value);
    }
}

