/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Event;
import edu.stanford.protege.webprotege.ipc.EventHandler;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarEventHandlerWrapper;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarEventHandlerWrapperFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.pulsar.client.api.PulsarClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class PulsarEventHandlersConfiguration {
    private static Logger logger = LoggerFactory.getLogger(PulsarEventHandlersConfiguration.class);
    @Autowired(required=false)
    private List<EventHandler<? extends Event>> eventHandlers = new ArrayList<EventHandler<? extends Event>>();
    @Autowired
    PulsarEventHandlerWrapperFactory wrapperFactory;

    @PostConstruct
    private void postConstruct() {
        logger.info("Event handlers configuration:");
        this.eventHandlers.forEach(handler -> {
            logger.info("Auto-detected event handler {} for channel {}", (Object)handler.getHandlerName(), (Object)handler.getChannelName());
            PulsarEventHandlerWrapper<?> wrapper = this.wrapperFactory.create((EventHandler<?>)handler);
            wrapper.subscribe();
        });
    }

    @Bean
    PulsarEventHandlerWrapperFactory pulsarEventHandlerWrapperFactory(@Value(value="${spring.application.name}") String applicationName, ObjectMapper objectMapper, PulsarClient pulsarClient, @Value(value="${webprotege.pulsar.tenant}") String tenant) {
        return handler -> this.pulsarEventHandlerWrapper(handler, applicationName, objectMapper, pulsarClient, tenant);
    }

    @Bean
    @Scope(value="prototype")
    public PulsarEventHandlerWrapper<?> pulsarEventHandlerWrapper(EventHandler<?> handler, String applicationName, ObjectMapper objectMapper, PulsarClient pulsarClient, @Value(value="${webprotege.pulsar.tenant}") String tenant) {
        return new PulsarEventHandlerWrapper(applicationName, tenant, handler, objectMapper, pulsarClient);
    }
}

