/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.ipc.GenericEventHandler;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarGenericEventHandlerWrapper;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarGenericEventHandlerWrapperFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.pulsar.client.api.PulsarClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class PulsarGenericEventHandlersConfiguration {
    private static Logger logger = LoggerFactory.getLogger(PulsarGenericEventHandlersConfiguration.class);
    @Autowired(required=false)
    private List<GenericEventHandler> eventHandlers = new ArrayList<GenericEventHandler>();
    @Autowired
    PulsarGenericEventHandlerWrapperFactory wrapperFactory;

    @PostConstruct
    private void postConstruct() {
        logger.info("Event handlers configuration:");
        this.eventHandlers.forEach(handler -> {
            logger.info("Auto-detected generic event handler: {}", (Object)handler.getHandlerName());
            PulsarGenericEventHandlerWrapper wrapper = this.wrapperFactory.create((GenericEventHandler)handler);
            wrapper.subscribe();
        });
    }

    @Bean
    PulsarGenericEventHandlerWrapperFactory pulsarGenericEventHandlerWrapperFactory(@Value(value="${spring.application.name}") String applicationName, ObjectMapper objectMapper, PulsarClient pulsarClient, @Value(value="${webprotege.pulsar.tenant}") String tenant) {
        return handler -> this.pulsarGenericEventHandlerWrapper(handler, applicationName, objectMapper, pulsarClient, tenant);
    }

    @Bean
    @Scope(value="prototype")
    public PulsarGenericEventHandlerWrapper pulsarGenericEventHandlerWrapper(GenericEventHandler handler, String applicationName, ObjectMapper objectMapper, PulsarClient pulsarClient, @Value(value="${webprotege.pulsar.tenant}") String tenant) {
        return new PulsarGenericEventHandlerWrapper(applicationName, tenant, pulsarClient, handler, objectMapper);
    }
}

