/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class PulsarProducersManager {
    private static final Logger logger = LoggerFactory.getLogger(PulsarProducersManager.class);
    private final PulsarClient pulsarClient;
    private final String applicationName;
    private final Cache<String, Producer<byte[]>> cache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(this::handleProducerRemoved).build();

    private void handleProducerRemoved(@Nullable String topicUrl, @Nullable Producer<byte[]> producer, @NonNull RemovalCause removalCause) {
        if (producer != null) {
            producer.closeAsync();
        }
    }

    public PulsarProducersManager(PulsarClient pulsarClient, @Value(value="${spring.application.name}") String applicationName) {
        this.pulsarClient = pulsarClient;
        this.applicationName = applicationName;
    }

    public Producer<byte[]> getProducer(String topicUrl) {
        return this.getProducer(topicUrl, producerBuilder -> {});
    }

    public Producer<byte[]> getProducer(String topicUrl, Consumer<ProducerBuilder<byte[]>> producerCustomizer) {
        return (Producer)this.cache.get((Object)topicUrl, u -> this.createProducer((String)u, producerCustomizer));
    }

    private Producer<byte[]> createProducer(String topicUrl, Consumer<ProducerBuilder<byte[]>> producerCustomizer) {
        try {
            ProducerBuilder producerBuilder = this.pulsarClient.newProducer().topic(topicUrl);
            producerCustomizer.accept((ProducerBuilder<byte[]>)producerBuilder);
            return producerBuilder.create();
        }
        catch (PulsarClientException e) {
            logger.error("Error when creating Pulsar Producer", (Throwable)e);
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

