/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusRequest;
import edu.stanford.protege.webprotege.authorization.GetAuthorizationStatusResponse;
import edu.stanford.protege.webprotege.common.Request;
import edu.stanford.protege.webprotege.common.Response;
import edu.stanford.protege.webprotege.common.WebProtegeCommonConfiguration;
import edu.stanford.protege.webprotege.ipc.CommandExecutor;
import edu.stanford.protege.webprotege.ipc.CommandHandler;
import edu.stanford.protege.webprotege.ipc.EventDispatcher;
import edu.stanford.protege.webprotege.ipc.MessageChannelMapper;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarCommandExecutor;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarCommandHandlerWrapper;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarCommandHandlerWrapperFactory;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarEventDispatcher;
import edu.stanford.protege.webprotege.ipc.pulsar.PulsarProducersManager;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.PulsarAdminBuilderImpl;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

@SpringBootApplication
@Import(value={WebProtegeCommonConfiguration.class})
@EnableCaching
public class WebProtegeIpcApplication {
    private static final Logger logger = LoggerFactory.getLogger(WebProtegeIpcApplication.class);
    @Value(value="${webprotege.pulsar.tenant}")
    private String tenant;
    @Value(value="${webprotege.pulsar.serviceHttpUrl}")
    private String serviceHttpUrl;
    @Value(value="${webprotege.pulsar.serviceUrl}")
    private String pulsarServiceUrl;

    public static void main(String[] args) {
        SpringApplication.run(WebProtegeIpcApplication.class, (String[])args);
    }

    @Bean
    MessageChannelMapper messageChannelMapper(@Value(value="${spring.application.name}") String serviceName) {
        return new MessageChannelMapper(serviceName);
    }

    @Bean
    EventDispatcher eventDispatcher(@Value(value="${spring.application.name}") String applicationName, PulsarProducersManager pulsarProducersManager, ObjectMapper objectMapper) {
        return new PulsarEventDispatcher(applicationName, pulsarProducersManager, objectMapper, this.tenant);
    }

    @Bean
    PulsarCommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> executorForGetAuthorizationStatusRequest() {
        return new PulsarCommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse>(GetAuthorizationStatusResponse.class);
    }

    @Bean
    PulsarAdmin pulsarAdmin() {
        try {
            PulsarAdmin admin = new PulsarAdminBuilderImpl().serviceHttpUrl(this.serviceHttpUrl).build();
            this.createTenantIfNecessary(admin);
            this.createNamespaceIfNecessary(admin, "command-requests");
            this.createNamespaceIfNecessary(admin, "command-responses");
            this.createNamespaceIfNecessary(admin, "events");
            return admin;
        }
        catch (PulsarAdminException | PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTenantIfNecessary(PulsarAdmin admin) throws PulsarAdminException {
        if (!admin.tenants().getTenants().contains(this.tenant)) {
            logger.info("Creating Pulsar tenant: {}", (Object)this.tenant);
            admin.tenants().createTenant(this.tenant, (TenantInfo)new TenantInfoImpl(Set.of("admin"), Set.of("standalone")));
        }
    }

    private void createNamespaceIfNecessary(PulsarAdmin admin, String namespace) throws PulsarAdminException {
        String namespaceName = this.tenant + "/" + namespace;
        if (!admin.namespaces().getNamespaces(this.tenant).contains(namespaceName)) {
            logger.info("Creating Pulsar namespace: {}", (Object)namespaceName);
            admin.namespaces().createNamespace(namespaceName);
        }
    }

    @Bean
    PulsarClient pulsarClient() throws PulsarClientException {
        return PulsarClient.builder().connectionTimeout(3, TimeUnit.MINUTES).serviceUrl(this.pulsarServiceUrl).build();
    }

    @Bean
    PulsarProducersManager pulsarProducersManager(PulsarClient pulsarClient, @Value(value="${spring.application.name}") String applicationName) {
        return new PulsarProducersManager(pulsarClient, applicationName);
    }

    @Bean
    PulsarCommandHandlerWrapperFactory pulsarCommandHandlerWrapperFactory(final @Value(value="${spring.application.name}") String applicationName, final ObjectMapper objectMapper, final PulsarProducersManager producersManager, final CommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> authorizationStatusExecutor, final PulsarClient pulsarClient) {
        return new PulsarCommandHandlerWrapperFactory(){

            @Override
            public <Q extends Request<R>, R extends Response> PulsarCommandHandlerWrapper<Q, R> create(CommandHandler<Q, R> handler) {
                return WebProtegeIpcApplication.this.pulsarCommandHandlerWrapper(handler, applicationName, pulsarClient, objectMapper, producersManager, authorizationStatusExecutor);
            }
        };
    }

    @Bean
    @Scope(value="prototype")
    public <Q extends Request<R>, R extends Response> PulsarCommandHandlerWrapper<Q, R> pulsarCommandHandlerWrapper(CommandHandler<Q, R> handler, String applicationName, PulsarClient pulsarClient, ObjectMapper objectMapper, PulsarProducersManager producersManager, CommandExecutor<GetAuthorizationStatusRequest, GetAuthorizationStatusResponse> authorizationStatusExecutor) {
        return new PulsarCommandHandlerWrapper<Q, R>(applicationName, this.tenant, pulsarClient, handler, objectMapper, producersManager, authorizationStatusExecutor);
    }

    @Bean
    Caffeine<Object, Object> pulsarProducerCaffeineConfig() {
        return Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES);
    }

    @Bean
    public CacheManager cacheManager(Caffeine<Object, Object> caffeine) {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager();
        caffeineCacheManager.setCaffeine(caffeine);
        return caffeineCacheManager;
    }
}

