/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.pulsar;

import javax.annotation.PostConstruct;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PulsarCommandExecutorsConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PulsarCommandExecutorsConfiguration.class);
    private final PulsarAdmin pulsarAdmin;
    private final String tenant;
    private final int commandSubscriptionExpiraryTime;

    public PulsarCommandExecutorsConfiguration(PulsarAdmin pulsarAdmin, @Value(value="${webprotege.pulsar.tenant}") String tenant, @Value(value="${webprotege.pulsar.command-replies.subscriptionExpiraryTimeMinutes}") int commandSubscriptionExpiraryTime) {
        this.pulsarAdmin = pulsarAdmin;
        this.tenant = tenant;
        this.commandSubscriptionExpiraryTime = commandSubscriptionExpiraryTime;
    }

    @PostConstruct
    public void setSubscriptionExpirationsForCommands() {
        logger.info("Setting subscription expiration time for command reply subscriptions to {} minutes", (Object)this.commandSubscriptionExpiraryTime);
        this.pulsarAdmin.namespaces().setSubscriptionExpirationTimeAsync(this.tenant + "/command-responses", this.commandSubscriptionExpiraryTime);
    }
}

