/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.ipc.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.stanford.protege.webprotege.common.Request;
import edu.stanford.protege.webprotege.common.Response;
import edu.stanford.protege.webprotege.ipc.CommandExecutionException;
import edu.stanford.protege.webprotege.ipc.CommandExecutor;
import edu.stanford.protege.webprotege.ipc.ExecutionContext;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class CommandExecutorImpl<Q extends Request<R>, R extends Response>
implements CommandExecutor<Q, R> {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutorImpl.class);
    private final Class<R> responseClass;
    private ObjectMapper objectMapper;
    private AsyncRabbitTemplate asyncRabbitTemplate;

    public CommandExecutorImpl(Class<R> responseClass) {
        this.responseClass = responseClass;
    }

    @Override
    public CompletableFuture<R> execute(Q request, ExecutionContext executionContext) {
        try {
            byte[] json = this.objectMapper.writeValueAsBytes(request);
            Message rabbitRequest = new Message(json);
            rabbitRequest.getMessageProperties().getHeaders().put("webprotege_accessToken", executionContext.jwt());
            rabbitRequest.getMessageProperties().getHeaders().put("webprotege_userId", executionContext.userId().id());
            rabbitRequest.getMessageProperties().getHeaders().put("webprotege_methodName", request.getChannel());
            return this.asyncRabbitTemplate.sendAndReceive(request.getChannel(), rabbitRequest).thenApply(this::handleResponse);
        }
        catch (Exception e) {
            logger.error("Error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private R handleResponse(Message rabbitResponse) {
        String exception = (String)rabbitResponse.getMessageProperties().getHeaders().get("webprotege_error");
        if (exception != null) {
            try {
                logger.error("Found error on response {}. Action : {}", (Object)exception, rabbitResponse.getMessageProperties().getHeaders().get("webprotege_methodName"));
                throw (CommandExecutionException)this.objectMapper.readValue(exception, CommandExecutionException.class);
            }
            catch (JsonProcessingException e) {
                logger.error("Error ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            return (R)((Response)this.objectMapper.readValue(rabbitResponse.getBody(), this.responseClass));
        }
        catch (IOException e) {
            logger.error("Error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Autowired
    @Qualifier(value="asyncRabbitTemplate")
    @Lazy
    public void setAsyncRabbitTemplate(AsyncRabbitTemplate asyncRabbitTemplate) {
        this.asyncRabbitTemplate = asyncRabbitTemplate;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

